/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.BundleResourceContext;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.system.configuration.DependencyManager;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleDeploymentContext
extends EARContext {
    private Bundle bundle;

    public BundleDeploymentContext(Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, BundleContext bundleContext, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, Map messageDestinations, Bundle bundle) throws DeploymentException {
        super(null, null, environment, moduleType, naming, configurationManager, (ResourceContext)new BundleResourceContext(bundle), bundleContext, serverName, baseName, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, messageDestinations);
        this.bundle = bundle;
    }

    public void initializeConfiguration() throws DeploymentException {
        try {
            ConfigurationData configurationData = new ConfigurationData(this.moduleType, null, this.childConfigurationDatas, this.environment, this.baseDir, this.inPlaceConfigurationDir, this.naming);
            configurationData.setBundleContext(this.bundle.getBundleContext());
            this.createTempPluginMetadata(this.bundle);
            DependencyManager.updatePluginMetadata((BundleContext)this.bundle.getBundleContext(), (Bundle)this.bundle);
            this.configurationManager.loadConfiguration(configurationData);
            this.configuration = this.configurationManager.getConfiguration(this.environment.getConfigId());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to create configuration for deployment", (Throwable)e);
        }
    }

    public void getCompleteManifestClassPath(Deployable deployable, URI moduleBaseUri, URI resolutionUri, Collection<String> classpath, Collection<String> exclusions) throws DeploymentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempPluginMetadata(Bundle bundle) throws FileNotFoundException, XMLStreamException, JAXBException {
        File geronimoPlugin = bundle.getBundleContext().getDataFile("geronimo-plugin.xml");
        FileOutputStream geronimoPluginOut = null;
        try {
            geronimoPluginOut = new FileOutputStream(geronimoPlugin);
            PluginType pluginMetadata = this.getPluginMetadata();
            PluginXmlUtil.writePluginMetadata((PluginType)pluginMetadata, (OutputStream)geronimoPluginOut);
        }
        catch (Throwable throwable) {
            IOUtils.close(geronimoPluginOut);
            throw throwable;
        }
        IOUtils.close((Closeable)geronimoPluginOut);
    }
}

