/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import org.apache.geronimo.j2ee.deployment.util.CircularReferencesException;
import org.apache.geronimo.j2ee.deployment.util.IllegalConfigurationException;
import org.apache.geronimo.kernel.util.JoinUtils;

public class FragmentSortUtils {
    public static <T> List<T> sort(Collection<T> objects, Visitor<T> visitor) throws IllegalConfigurationException, CircularReferencesException {
        if (objects.size() == 0) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (T obj : objects) {
            String name = visitor.getName(obj);
            Node node = new Node(name, obj, visitor.afterOthers(obj), visitor.beforeOthers(obj), visitor.getAfterNames(obj), visitor.getBeforeNames(obj));
            if (node.beforeOthers && node.afterOthers) {
                throw new IllegalConfigurationException(name, "Before others and after others could not be configured at the sametime ");
            }
            nodes.put(name, node);
        }
        for (Node node : nodes.values()) {
            if (node.after.contains(node.name)) {
                throw new IllegalConfigurationException(node.name, "The fragment could not be configured to after itself");
            }
            for (String afterNodeName : node.after) {
                Node afterNode = (Node)nodes.get(afterNodeName);
                if (afterNode == null) continue;
                node.dependOns.add(afterNode);
            }
            if (node.before.contains(node.name)) {
                throw new IllegalConfigurationException(node.name, "The fragment could not be configured to before itself");
            }
            for (String beforeNodeName : node.before) {
                Node beforeNode = (Node)nodes.get(beforeNodeName);
                if (beforeNode == null) continue;
                beforeNode.dependOns.add(node);
            }
        }
        boolean circuitFounded = false;
        for (Node node : nodes.values()) {
            HashSet<Node<T>> visitedNodes;
            if (!FragmentSortUtils.normalizeNodeReferences(node, node, visitedNodes = new HashSet<Node<T>>())) {
                circuitFounded = true;
                break;
            }
            node.dependOns.addAll(visitedNodes);
        }
        if (circuitFounded) {
            LinkedHashSet<Circuit<T>> circuits = new LinkedHashSet<Circuit<T>>();
            for (Node node : nodes.values()) {
                FragmentSortUtils.findCircuits(circuits, node, new Stack<Node<T>>());
            }
            ArrayList list = new ArrayList(circuits);
            Collections.sort(list);
            ArrayList<List> all = new ArrayList<List>();
            for (Circuit circuit : list) {
                all.add(FragmentSortUtils.unwrap(circuit.nodes));
            }
            throw new CircularReferencesException(all);
        }
        Node rootNode = new Node();
        rootNode.previous = rootNode;
        rootNode.next = (Node)nodes.values().iterator().next();
        for (Node node : nodes.values()) {
            node.previous = rootNode.previous;
            rootNode.previous.next = node;
            node.next = rootNode;
            rootNode.previous = node;
        }
        Node lastBeforeNode = rootNode;
        for (Node node : nodes.values()) {
            if (node.beforeOthers) {
                FragmentSortUtils.moveAfter(node, lastBeforeNode);
                lastBeforeNode = node;
                continue;
            }
            if (!node.afterOthers) continue;
            FragmentSortUtils.moveBefore(node, rootNode);
        }
        for (Node node : nodes.values()) {
            for (Node reference : node.dependOns) {
                FragmentSortUtils.swap(node, reference, rootNode);
            }
        }
        ArrayList sortedList = new ArrayList(nodes.size());
        Node currentNode = rootNode.next;
        while (currentNode != rootNode) {
            sortedList.add(currentNode.object);
            currentNode = currentNode.next;
        }
        return sortedList;
    }

    private static <T> boolean normalizeNodeReferences(Node<T> rootNode, Node<T> node, Set<Node<T>> dependOns) {
        if (node.dependOns.contains(rootNode)) {
            return false;
        }
        for (Node reference : node.dependOns) {
            if (!dependOns.add(reference) || FragmentSortUtils.normalizeNodeReferences(rootNode, reference, dependOns)) continue;
            return false;
        }
        return true;
    }

    private static <T> void moveAfter(Node<T> insertNode, Node<T> targetNode) {
        insertNode.previous.next = insertNode.next;
        insertNode.next.previous = insertNode.previous;
        targetNode.next.previous = insertNode;
        insertNode.next = targetNode.next;
        targetNode.next = insertNode;
        insertNode.previous = targetNode;
    }

    private static <T> void moveBefore(Node<T> insertNode, Node<T> targetNode) {
        insertNode.previous.next = insertNode.next;
        insertNode.next.previous = insertNode.previous;
        targetNode.previous.next = insertNode;
        insertNode.previous = targetNode.previous;
        insertNode.next = targetNode;
        targetNode.previous = insertNode;
    }

    private static <T> void swap(Node<T> shouldAfterNode, Node<T> shouldBeforeNode, Node<T> rootNode) {
        Node<T> currentNode = shouldBeforeNode;
        while (currentNode.next != rootNode) {
            if (currentNode.next == shouldAfterNode) {
                return;
            }
            currentNode = currentNode.next;
        }
        shouldAfterNode.previous.next = shouldAfterNode.next;
        shouldAfterNode.next.previous = shouldAfterNode.previous;
        shouldAfterNode.previous = shouldBeforeNode;
        shouldAfterNode.next = shouldBeforeNode.next;
        shouldBeforeNode.next = shouldAfterNode;
        shouldAfterNode.next.previous = shouldAfterNode;
    }

    private static <T> List<T> unwrap(List<Node<T>> nodes) {
        ArrayList referees = new ArrayList(nodes.size());
        for (Node<T> node : nodes) {
            referees.add(node.object);
        }
        return referees;
    }

    private static <T> void findCircuits(Set<Circuit<T>> circuits, Node<T> node, Stack<Node<T>> stack) {
        if (stack.contains(node)) {
            int fromIndex = stack.indexOf(node);
            int toIndex = stack.size();
            ArrayList circularity = new ArrayList(stack.subList(fromIndex, toIndex));
            circularity.add(node);
            Circuit circuit = new Circuit(circularity);
            circuits.add(circuit);
            return;
        }
        stack.push(node);
        for (Node reference : node.dependOns) {
            FragmentSortUtils.findCircuits(circuits, reference, stack);
        }
        stack.pop();
    }

    private static class Circuit<T>
    implements Comparable<Circuit<T>> {
        private final List<Node<T>> nodes;
        private final List<Node<T>> atomic;

        public Circuit(List<Node<T>> nodes) {
            this.nodes = nodes;
            this.atomic = new ArrayList<Node<T>>(nodes);
            this.atomic.remove(this.atomic.size() - 1);
            Collections.sort(this.atomic);
        }

        public List<Node<T>> getNodes() {
            return this.nodes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Circuit circuit = (Circuit)o;
            return ((Object)this.atomic).equals(circuit.atomic);
        }

        public int hashCode() {
            return ((Object)this.atomic).hashCode();
        }

        @Override
        public int compareTo(Circuit<T> o) {
            int i = this.atomic.size() - o.atomic.size();
            if (i != 0) {
                return i;
            }
            ListIterator<Node<T>> iterA = this.atomic.listIterator();
            ListIterator<Node<T>> iterB = o.atomic.listIterator();
            while (iterA.hasNext() && iterB.hasNext()) {
                Node b;
                Node a = (Node)iterA.next();
                i = a.compareTo(b = (Node)iterB.next());
                if (i == 0) continue;
                return i;
            }
            return 0;
        }

        public String toString() {
            return "Circuit(" + JoinUtils.join((String)",", (Collection)FragmentSortUtils.unwrap(this.nodes)) + ")";
        }
    }

    private static class Node<T>
    implements Comparable<Node<T>> {
        public String name;
        public T object;
        public List<String> after = new ArrayList<String>();
        public List<String> before = new ArrayList<String>();
        public boolean afterOthers;
        public boolean beforeOthers;
        public final Set<Node<T>> dependOns = new HashSet<Node<T>>();
        public Node<T> next;
        public Node<T> previous;

        public Node() {
        }

        public Node(String name, T object, boolean afterOthers, boolean beforeOthers, List<String> after, List<String> before) {
            this.name = name;
            this.object = object;
            this.afterOthers = afterOthers;
            this.beforeOthers = beforeOthers;
            this.before = before;
            this.after = after;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.name.equals(node.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Node<T> o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Visitor<T> {
        public String getName(T var1);

        public List<String> getAfterNames(T var1);

        public List<String> getBeforeNames(T var1);

        public boolean afterOthers(T var1);

        public boolean beforeOthers(T var1);
    }
}

