/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.geronimo.j2ee.deployment.annotation.HandlerChainAnnotationHelper;
import org.apache.openejb.jee.Addressing;
import org.apache.openejb.jee.AddressingResponses;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.PortComponentRef;
import org.apache.openejb.jee.RespectBinding;
import org.apache.openejb.jee.ServiceRef;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebServiceRefAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(WebServiceRefAnnotationHelper.class);

    private WebServiceRefAnnotationHelper() {
    }

    public static void processAnnotations(JndiConsumer specDD, AbstractFinder classFinder) throws DeploymentException {
        if (specDD != null) {
            if (classFinder.isAnnotationPresent(WebServiceRefs.class)) {
                WebServiceRefAnnotationHelper.processWebServiceRefs(specDD, classFinder);
            }
            if (classFinder.isAnnotationPresent(WebServiceRef.class)) {
                WebServiceRefAnnotationHelper.processWebServiceRef(specDD, classFinder);
            }
        }
    }

    private static void processWebServiceRef(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        WebServiceRef webServiceRef;
        if (log.isDebugEnabled()) {
            log.debug("processWebServiceRef(): Entry: AnnotatedApp: " + annotatedApp.toString());
        }
        List classeswithWebServiceRef = classFinder.findAnnotatedClasses(WebServiceRef.class);
        List methodswithWebServiceRef = classFinder.findAnnotatedMethods(WebServiceRef.class);
        List fieldswithWebServiceRef = classFinder.findAnnotatedFields(WebServiceRef.class);
        for (Class cls : classeswithWebServiceRef) {
            webServiceRef = cls.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null) continue;
            WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, cls, null, null);
        }
        for (Method method : methodswithWebServiceRef) {
            webServiceRef = method.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null) continue;
            WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, null, method, null);
        }
        for (Field field : fieldswithWebServiceRef) {
            webServiceRef = field.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null) continue;
            WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, null, null, field);
        }
        if (log.isDebugEnabled()) {
            log.debug("processWebServiceRef(): Exit: AnnotatedApp: " + annotatedApp.toString());
        }
    }

    private static void processWebServiceRefs(JndiConsumer annotatedApp, AbstractFinder classFinder) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug("processWebServiceRefs(): Entry");
        }
        List classeswithWebServiceRefs = classFinder.findAnnotatedClasses(WebServiceRefs.class);
        ArrayList<WebServiceRef> webServiceRefList = new ArrayList<WebServiceRef>();
        for (Class cls : classeswithWebServiceRefs) {
            WebServiceRefs webServiceRefs = cls.getAnnotation(WebServiceRefs.class);
            if (webServiceRefs != null) {
                webServiceRefList.addAll(Arrays.asList(webServiceRefs.value()));
            }
            for (WebServiceRef webServiceRef : webServiceRefList) {
                WebServiceRefAnnotationHelper.addWebServiceRef(annotatedApp, webServiceRef, cls, null, null);
            }
            webServiceRefList.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug("processWebServiceRefs(): Exit");
        }
    }

    private static void addWebServiceRef(JndiConsumer annotatedApp, WebServiceRef annotation, Class cls, Method method, Field field) {
        if (log.isDebugEnabled()) {
            log.debug("addWebServiceRef( [annotatedApp] " + annotatedApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
        }
        String webServiceRefName = WebServiceRefAnnotationHelper.getName(annotation.name(), method, field);
        if (log.isDebugEnabled()) {
            log.debug("addWebServiceRef(): webServiceRefName: " + webServiceRefName);
        }
        Class<?> webServiceRefType = annotation.type();
        Class webServiceRefValue = annotation.value();
        if (webServiceRefType == null || webServiceRefType.equals(Object.class)) {
            if (method != null) {
                webServiceRefType = method.getParameterTypes()[0];
            } else if (field != null) {
                webServiceRefType = field.getType();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("addWebServiceRef(): webServiceRefType: " + webServiceRefType);
            log.debug("addWebServiceRef(): webServiceRefValue: " + webServiceRefValue);
        }
        ServiceRef serviceRef = null;
        Collection serviceRefs = annotatedApp.getServiceRef();
        for (ServiceRef currServiceRef : serviceRefs) {
            if (!currServiceRef.getServiceRefName().trim().equals(webServiceRefName)) continue;
            serviceRef = currServiceRef;
            break;
        }
        if (serviceRef == null) {
            serviceRef = new ServiceRef();
            serviceRef.setServiceRefName(webServiceRefName);
            if (webServiceRefValue == Service.class) {
                serviceRef.setServiceInterface(webServiceRefType.getName());
            } else {
                serviceRef.setServiceInterface(webServiceRefValue.getName());
            }
            annotatedApp.getServiceRef().add(serviceRef);
        }
        if (serviceRef.getLookupName() == null && !annotation.lookup().trim().isEmpty()) {
            serviceRef.setLookupName(annotation.lookup().trim());
        }
        if (serviceRef.getServiceRefType() == null && !webServiceRefType.equals(Object.class)) {
            serviceRef.setServiceRefType(webServiceRefType.getName());
        }
        if (serviceRef.getMappedName() == null && annotation.mappedName().trim().length() > 0) {
            serviceRef.setMappedName(annotation.mappedName().trim());
        }
        if (serviceRef.getWsdlFile() == null) {
            String wsdlLocation = annotation.wsdlLocation();
            if (wsdlLocation == null || wsdlLocation.trim().length() == 0) {
                WebServiceClient wsClient = null;
                wsClient = Service.class == webServiceRefValue ? webServiceRefType.getAnnotation(WebServiceClient.class) : webServiceRefValue.getAnnotation(WebServiceClient.class);
                wsdlLocation = wsClient == null ? null : wsClient.wsdlLocation();
            }
            if (wsdlLocation != null && wsdlLocation.trim().length() > 0) {
                serviceRef.setWsdlFile(wsdlLocation);
            }
        }
        if (serviceRef.getHandlerChains() == null) {
            HandlerChain handlerChain = null;
            Class annotatedClass = null;
            if (method != null) {
                handlerChain = method.getAnnotation(HandlerChain.class);
                annotatedClass = method.getDeclaringClass();
            } else if (field != null) {
                handlerChain = field.getAnnotation(HandlerChain.class);
                annotatedClass = field.getDeclaringClass();
            }
            if (handlerChain == null) {
                if (Service.class == webServiceRefValue) {
                    handlerChain = webServiceRefType.getAnnotation(HandlerChain.class);
                    annotatedClass = webServiceRefType;
                } else {
                    handlerChain = webServiceRefValue.getAnnotation(HandlerChain.class);
                    annotatedClass = webServiceRefValue;
                }
            }
            if (handlerChain != null) {
                HandlerChainAnnotationHelper.insertHandlers(serviceRef, handlerChain, annotatedClass);
            }
        }
        if (method != null || field != null) {
            serviceRef.getInjectionTarget().add(WebServiceRefAnnotationHelper.configureInjectionTarget(method, field));
        }
        Annotation[] candidateAnnotations = null;
        if (cls != null) {
            candidateAnnotations = cls.getAnnotations();
        } else if (method != null) {
            candidateAnnotations = method.getAnnotations();
        } else if (field != null) {
            candidateAnnotations = field.getAnnotations();
        }
        if (candidateAnnotations != null && candidateAnnotations.length > 0) {
            ArrayList<Annotation> webServiceFeatureAnnotations = new ArrayList<Annotation>();
            for (Annotation anno : candidateAnnotations) {
                if (!anno.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) continue;
                webServiceFeatureAnnotations.add(anno);
            }
            if (webServiceFeatureAnnotations.size() > 0) {
                if (Service.class.isAssignableFrom(webServiceRefType)) {
                    log.warn("In current JAX-WS spec, no standard web service feature is supported on service creation, " + webServiceFeatureAnnotations + " are ignored");
                } else {
                    PortComponentRef portComponentRef = WebServiceRefAnnotationHelper.getPortComponentRef(serviceRef, webServiceRefType.getName());
                    for (Annotation webServiceFeatureAnnotation : webServiceFeatureAnnotations) {
                        Class<? extends Annotation> webServiceFeatureAnnotationType = webServiceFeatureAnnotation.annotationType();
                        if (webServiceFeatureAnnotationType == MTOM.class) {
                            MTOM mtom = (MTOM)webServiceFeatureAnnotation;
                            if (portComponentRef.getMtomThreshold() == null) {
                                portComponentRef.setMtomThreshold(Integer.valueOf(mtom.threshold()));
                            }
                            if (portComponentRef.getEnableMtom() != null) continue;
                            portComponentRef.setEnableMtom(mtom.enabled());
                            continue;
                        }
                        if (webServiceFeatureAnnotationType == javax.xml.ws.soap.Addressing.class) {
                            javax.xml.ws.soap.Addressing addressingAnnotation = (javax.xml.ws.soap.Addressing)webServiceFeatureAnnotation;
                            Addressing addressing = portComponentRef.getAddressing();
                            if (addressing == null) {
                                addressing = new Addressing();
                                addressing.setEnabled(Boolean.valueOf(addressingAnnotation.enabled()));
                                addressing.setRequired(Boolean.valueOf(addressingAnnotation.required()));
                                addressing.setResponses(AddressingResponses.valueOf((String)addressingAnnotation.responses().toString()));
                                portComponentRef.setAddressing(addressing);
                                continue;
                            }
                            if (addressing.getEnabled() == null) {
                                addressing.setEnabled(Boolean.valueOf(addressingAnnotation.enabled()));
                            }
                            if (addressing.getRequired() == null) {
                                addressing.setRequired(Boolean.valueOf(addressingAnnotation.required()));
                            }
                            if (addressing.getResponses() != null) continue;
                            addressing.setResponses(AddressingResponses.valueOf((String)addressingAnnotation.responses().toString()));
                            continue;
                        }
                        if (webServiceFeatureAnnotationType == javax.xml.ws.RespectBinding.class) {
                            javax.xml.ws.RespectBinding respectBinding = (javax.xml.ws.RespectBinding)webServiceFeatureAnnotation;
                            if (portComponentRef.getRespectBinding() != null) continue;
                            RespectBinding respectBindingValue = new RespectBinding();
                            respectBindingValue.setEnabled(Boolean.valueOf(respectBinding.enabled()));
                            portComponentRef.setRespectBinding(respectBindingValue);
                            continue;
                        }
                        log.warn("Unsupport web service feature annotation " + webServiceFeatureAnnotation + " on " + webServiceRefName);
                    }
                }
            }
        }
    }

    private static PortComponentRef getPortComponentRef(ServiceRef serviceRef, String seiInterfaceName) {
        List portComponentRefs = serviceRef.getPortComponentRef();
        for (PortComponentRef portComponentRef : portComponentRefs) {
            if (!portComponentRef.getServiceEndpointInterface().equals(seiInterfaceName)) continue;
            return portComponentRef;
        }
        PortComponentRef portComponentRef = new PortComponentRef();
        portComponentRef.setServiceEndpointInterface(seiInterfaceName);
        portComponentRefs.add(portComponentRef);
        return portComponentRef;
    }
}

