/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.util.List;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.Servlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotationHelper;
import org.apache.openejb.jee.SecurityRole;
import org.apache.openejb.jee.WebApp;
import org.apache.xbean.finder.AbstractFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityAnnotationHelper
extends AnnotationHelper {
    private static final Logger log = LoggerFactory.getLogger(SecurityAnnotationHelper.class);

    private SecurityAnnotationHelper() {
    }

    public static void processAnnotations(WebApp webApp, AbstractFinder classFinder) throws DeploymentException {
        if (webApp != null && classFinder != null) {
            if (classFinder.isAnnotationPresent(DeclareRoles.class)) {
                SecurityAnnotationHelper.processDeclareRoles(webApp, classFinder);
            }
            if (classFinder.isAnnotationPresent(RunAs.class)) {
                SecurityAnnotationHelper.processRunAs(webApp, classFinder);
            }
        }
    }

    private static void processDeclareRoles(WebApp webApp, AbstractFinder classFinder) throws DeploymentException {
        log.debug("processDeclareRoles(): Entry: webApp: " + webApp.toString());
        List classesWithDeclareRoles = classFinder.findAnnotatedClasses(DeclareRoles.class);
        for (Class cls : classesWithDeclareRoles) {
            DeclareRoles declareRoles = cls.getAnnotation(DeclareRoles.class);
            if (declareRoles == null || !Servlet.class.isAssignableFrom(cls)) continue;
            SecurityAnnotationHelper.addDeclareRoles(webApp, declareRoles, cls);
        }
        log.debug("processDeclareRoles(): Exit: webApp: " + webApp.toString());
    }

    private static void processRunAs(WebApp webApp, AbstractFinder classFinder) throws DeploymentException {
        log.debug("processRunAs(): Entry: webApp: " + webApp.toString());
        List classesWithRunAs = classFinder.findAnnotatedClasses(RunAs.class);
        for (Class cls : classesWithRunAs) {
            RunAs runAs = cls.getAnnotation(RunAs.class);
            if (runAs == null || !Servlet.class.isAssignableFrom(cls)) continue;
            SecurityAnnotationHelper.addRunAs(webApp, runAs, cls);
        }
        log.debug("processRunAs(): Exit: webApp: " + webApp.toString());
    }

    private static void addDeclareRoles(WebApp webApp, DeclareRoles annotation, Class cls) {
        String[] annotationRoleNames;
        log.debug("addDeclareRoles( [webApp] " + webApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "): Entry");
        List securityRoles = webApp.getSecurityRole();
        for (String annotationRoleName : annotationRoleNames = annotation.value()) {
            if (annotationRoleName.equals("")) continue;
            boolean exists = false;
            for (SecurityRole securityRole : securityRoles) {
                if (!securityRole.getRoleName().trim().equals(annotationRoleName)) continue;
                exists = true;
                break;
            }
            if (exists) {
                log.debug("addDeclareRoles: <security-role> entry found: " + annotationRoleName);
                continue;
            }
            log.debug("addDeclareRoles: <security-role> entry NOT found: " + annotationRoleName);
            SecurityRole securityRole = new SecurityRole();
            securityRole.setRoleName(annotationRoleName);
            webApp.getSecurityRole().add(securityRole);
        }
        log.debug("addDeclareRoles(): Exit");
    }

    private static void addRunAs(WebApp webApp, RunAs annotation, Class cls) {
        log.debug("addRunAs( [webApp] " + webApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "): Entry");
        String annotationRunAs = annotation.value();
        if (!annotationRunAs.equals("")) {
            List servlets = webApp.getServlet();
            boolean exists = false;
            for (org.apache.openejb.jee.Servlet servlet : servlets) {
                if (!servlet.getServletClass().trim().equals(cls.getName())) continue;
                if (servlet.getRunAs() == null) {
                    org.apache.openejb.jee.RunAs runAs = new org.apache.openejb.jee.RunAs();
                    runAs.setRoleName(annotationRunAs);
                    servlet.setRunAs(runAs);
                }
                exists = true;
                break;
            }
            if (!exists) {
                log.warn("RunAs servlet not found in webApp: " + cls.getName());
            }
        }
        log.debug("addRunAs(): Exit");
    }
}

