/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.openejb.jee.InjectionTarget;

public class AnnotationHelper {
    protected static String getName(String name, Method method, Field field) {
        String resourceName = name;
        if (resourceName.equals("")) {
            if (method != null) {
                StringBuilder stringBuilder = new StringBuilder(method.getName().substring(3));
                stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
                resourceName = method.getDeclaringClass().getName() + "/" + stringBuilder.toString();
            } else if (field != null) {
                resourceName = field.getDeclaringClass().getName() + "/" + field.getName();
            }
        }
        return resourceName;
    }

    protected static String getInjectionJavaType(Method method, Field field) {
        if (method != null) {
            String injectionJavaType = method.getName().substring(3);
            StringBuilder stringBuilder = new StringBuilder(injectionJavaType);
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
            return stringBuilder.toString();
        }
        if (field != null) {
            return field.getName();
        }
        throw new IllegalArgumentException("You must supply exactly one of Method, Field");
    }

    protected static String getInjectionClass(Method method, Field field) {
        if (method != null) {
            return method.getDeclaringClass().getName();
        }
        if (field != null) {
            return field.getDeclaringClass().getName();
        }
        throw new IllegalArgumentException("You must supply exactly one of Method, Field");
    }

    protected static boolean hasTarget(Method method, Field field, Set<InjectionTarget> targets) {
        String injectionJavaType = AnnotationHelper.getInjectionJavaType(method, field);
        String injectionClass = AnnotationHelper.getInjectionClass(method, field);
        for (InjectionTarget target : targets) {
            if (!injectionClass.equals(target.getInjectionTargetClass().trim()) || !injectionJavaType.equals(target.getInjectionTargetName().trim())) continue;
            return true;
        }
        return false;
    }

    protected static InjectionTarget configureInjectionTarget(Method method, Field field) {
        InjectionTarget injectionTarget = new InjectionTarget();
        String injectionJavaType = AnnotationHelper.getInjectionJavaType(method, field);
        String injectionClass = AnnotationHelper.getInjectionClass(method, field);
        injectionTarget.setInjectionTargetClass(injectionClass);
        injectionTarget.setInjectionTargetName(injectionJavaType);
        return injectionTarget;
    }

    protected static String getJndiName(String name) {
        if (name.indexOf(58) == -1) {
            return "java:comp/env/" + name.trim();
        }
        return name.trim();
    }
}

