/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARContext
extends DeploymentContext {
    private final AbstractNameQuery serverName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery transactedTimerName;
    private final AbstractNameQuery nonTransactedTimerName;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final Map contextIDToPermissionsMap = new HashMap();
    private AbstractName jaccManagerName;
    private Object securityConfiguration;
    private final Map messageDestinations;
    private final Map<Object, Object> generalData = new HashMap<Object, Object>();

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, Collection repositories, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery transactedTimerName, AbstractNameQuery nonTransactedTimerName, AbstractNameQuery corbaGBeanObjectName) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, baseName, moduleType, naming, configurationManager, repositories);
        this.serverName = serverName;
        this.transactionManagerObjectName = transactionManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactedTimerName = transactedTimerName;
        this.nonTransactedTimerName = nonTransactedTimerName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.messageDestinations = new HashMap();
    }

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery transactedTimerName, AbstractNameQuery nonTransactedTimerName, AbstractNameQuery corbaGBeanObjectName, Map messageDestinations) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, baseName, moduleType, naming, configurationManager);
        this.serverName = serverName;
        this.transactionManagerObjectName = transactionManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactedTimerName = transactedTimerName;
        this.nonTransactedTimerName = nonTransactedTimerName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.messageDestinations = messageDestinations;
    }

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, AbstractName baseName, EARContext parent) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, baseName, moduleType, parent.getNaming(), parent.getConfigurationManager());
        this.serverName = parent.getServerName();
        this.transactionManagerObjectName = parent.getTransactionManagerName();
        this.connectionTrackerObjectName = parent.getConnectionTrackerName();
        this.transactedTimerName = parent.getTransactedTimerName();
        this.nonTransactedTimerName = parent.getNonTransactedTimerName();
        this.corbaGBeanObjectName = parent.getCORBAGBeanName();
        this.messageDestinations = new HashMap();
    }

    public AbstractNameQuery getServerName() {
        return this.serverName;
    }

    public AbstractNameQuery getTransactionManagerName() {
        return this.transactionManagerObjectName;
    }

    public AbstractNameQuery getConnectionTrackerName() {
        return this.connectionTrackerObjectName;
    }

    public AbstractNameQuery getTransactedTimerName() {
        return this.transactedTimerName;
    }

    public AbstractNameQuery getNonTransactedTimerName() {
        return this.nonTransactedTimerName;
    }

    public AbstractNameQuery getCORBAGBeanName() {
        return this.corbaGBeanObjectName;
    }

    public Map getContextIDToPermissionsMap() {
        return this.contextIDToPermissionsMap;
    }

    public void addSecurityContext(String contextID, Object componentPermissions) throws DeploymentException {
        Object old = this.contextIDToPermissionsMap.put(contextID, componentPermissions);
        if (old != null) {
            throw new DeploymentException("Duplicate contextID registered! " + contextID);
        }
    }

    public void setJaccManagerName(AbstractName jaccManagerName) {
        this.jaccManagerName = jaccManagerName;
    }

    public AbstractName getJaccManagerName() {
        return this.jaccManagerName;
    }

    public void setSecurityConfiguration(Object securityConfiguration) throws DeploymentException {
        if (this.securityConfiguration != null) {
            throw new DeploymentException("Only one security configuration allowed per application");
        }
        this.securityConfiguration = securityConfiguration;
    }

    public Object getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void registerMessageDestionations(String moduleName, Map nameMap) throws DeploymentException {
        this.messageDestinations.put(moduleName, nameMap);
    }

    public Map getMessageDestinations() {
        return this.messageDestinations;
    }

    public Map<Object, Object> getGeneralData() {
        return this.generalData;
    }
}

