/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geronimo.farm.discovery.DiscoveryAgent;
import org.apache.geronimo.farm.discovery.DiscoveryListener;
import org.apache.geronimo.farm.discovery.MulticastLocation;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class MulticastDiscoveryAgent
implements DiscoveryAgent,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(MulticastDiscoveryAgent.class);
    private static final int BUFF_SIZE = 8192;
    private AtomicBoolean started = new AtomicBoolean(false);
    private MulticastSocket multicast;
    private String host = "239.255.3.2";
    private int port = 6142;
    private int timeToLive = 1;
    private boolean loopbackMode = false;
    private SocketAddress address;
    private Map<String, Service> registeredServices = new ConcurrentHashMap<String, Service>();
    private int maxMissedHeartbeats = 10;
    private long heartRate = 500L;
    private final Listener listener;
    private long initialReconnectDelay = 5000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 0L;
    private boolean useExponentialBackOff;
    private int maxReconnectAttempts = 10;

    public MulticastDiscoveryAgent() {
        this.listener = new Listener();
    }

    public MulticastDiscoveryAgent(@ParamReference(name="MulticastLocation") MulticastLocation location, @ParamAttribute(name="heartRate") long heartRate, @ParamAttribute(name="maxMissedHeartbeats") int maxMissedHeartbeats, @ParamAttribute(name="loopbackMode") boolean loopbackMode, @ParamAttribute(name="initialReconnectDelay") long initialReconnectDelay, @ParamAttribute(name="maxReconnectDelay") long maxReconnectDelay, @ParamAttribute(name="maxReconnectAttempts") int maxReconnectAttempts, @ParamAttribute(name="backOffMultiplier") long backOffMultiplier, @ParamAttribute(name="useExponentialBackOff") boolean useExponentialBackOff) {
        this.host = location.getHost();
        this.port = location.getPort();
        this.heartRate = heartRate;
        this.maxMissedHeartbeats = maxMissedHeartbeats;
        this.loopbackMode = loopbackMode;
        this.initialReconnectDelay = initialReconnectDelay;
        this.maxReconnectDelay = maxReconnectDelay;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.backOffMultiplier = backOffMultiplier;
        this.useExponentialBackOff = useExponentialBackOff;
        this.listener = new Listener();
    }

    public String getIP() {
        return this.host;
    }

    public String getName() {
        return "multicast";
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void setDiscoveryListener(DiscoveryListener listener) {
        this.listener.setDiscoveryListener(listener);
    }

    @Override
    public void registerService(URI serviceUri) throws IOException {
        Service service = new Service(serviceUri);
        this.registeredServices.put(service.uriString, service);
    }

    @Override
    public void unregisterService(URI serviceUri) throws IOException {
        Service service = new Service(serviceUri);
        this.registeredServices.remove(service.uriString);
    }

    @Override
    public void reportFailed(URI serviceUri) throws IOException {
        this.listener.reportFailed(serviceUri);
    }

    private boolean isSelf(Service service) {
        return this.isSelf(service.uriString);
    }

    private boolean isSelf(String service) {
        return this.registeredServices.keySet().contains(service);
    }

    public static void main(String[] args) throws Exception {
    }

    public void doStart() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.newSocket();
            Thread listenerThread = new Thread(this.listener);
            listenerThread.setName("MulticastDiscovery: Listener");
            listenerThread.setDaemon(true);
            listenerThread.start();
            Broadcaster broadcaster = new Broadcaster();
            Timer timer = new Timer("MulticastDiscovery: Broadcaster", true);
            timer.scheduleAtFixedRate((TimerTask)broadcaster, 0L, this.heartRate);
        }
    }

    private void newSocket() throws IOException {
        InetAddress inetAddress = InetAddress.getByName(this.host);
        this.address = new InetSocketAddress(inetAddress, this.port);
        this.multicast = new MulticastSocket(this.port);
        this.multicast.setLoopbackMode(this.loopbackMode);
        this.multicast.setTimeToLive(this.timeToLive);
        this.multicast.joinGroup(inetAddress);
        this.multicast.setSoTimeout((int)this.heartRate);
    }

    public void doStop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            this.multicast.close();
        }
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Broadcaster
    extends TimerTask {
        private IOException failed;

        Broadcaster() {
        }

        @Override
        public void run() {
            if (MulticastDiscoveryAgent.this.started.get()) {
                this.heartbeat();
            }
        }

        private void heartbeat() {
            for (String uri : MulticastDiscoveryAgent.this.registeredServices.keySet()) {
                try {
                    byte[] data = uri.getBytes();
                    DatagramPacket packet = new DatagramPacket(data, 0, data.length, MulticastDiscoveryAgent.this.address);
                    MulticastDiscoveryAgent.this.multicast.send(packet);
                    this.failed = null;
                }
                catch (IOException e) {
                    try {
                        MulticastDiscoveryAgent.this.newSocket();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    if (this.failed != null) continue;
                    this.failed = e;
                    log.error("Failed to advertise our service: " + uri, (Throwable)e);
                    if (!"Operation not permitted".equals(e.getMessage())) continue;
                    log.error("The 'Operation not permitted' error has been know to be caused by improper firewall/network setup.  Please make sure that the OS is properly configured to allow multicast traffic over: " + MulticastDiscoveryAgent.this.multicast.getLocalAddress());
                }
            }
        }
    }

    class Listener
    implements Runnable {
        private Map<String, ServiceVitals> discoveredServices = new ConcurrentHashMap<String, ServiceVitals>();
        private DiscoveryListener discoveryListener;
        private final Executor executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "Multicast Discovery Agent Notifier");
                t.setDaemon(true);
                return t;
            }
        });

        Listener() {
        }

        public void setDiscoveryListener(DiscoveryListener discoveryListener) {
            this.discoveryListener = discoveryListener;
        }

        @Override
        public void run() {
            byte[] buf = new byte[8192];
            DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
            while (MulticastDiscoveryAgent.this.started.get()) {
                this.checkServices();
                try {
                    MulticastDiscoveryAgent.this.multicast.receive(packet);
                    if (packet.getLength() <= 0) continue;
                    String str = new String(packet.getData(), packet.getOffset(), packet.getLength());
                    this.processData(str);
                }
                catch (SocketTimeoutException se) {
                }
                catch (IOException e) {
                    if (!MulticastDiscoveryAgent.this.started.get()) continue;
                    log.error("failed to process packet: " + e);
                }
            }
        }

        private void processData(String uriString) {
            if (this.discoveryListener == null) {
                return;
            }
            if (MulticastDiscoveryAgent.this.isSelf(uriString)) {
                return;
            }
            ServiceVitals vitals = this.discoveredServices.get(uriString);
            if (vitals == null) {
                try {
                    vitals = new ServiceVitals(new Service(uriString));
                    this.discoveredServices.put(uriString, vitals);
                    this.fireServiceAddEvent(vitals.service.uri);
                }
                catch (URISyntaxException uRISyntaxException) {}
            } else {
                vitals.heartbeat();
                if (vitals.doRecovery()) {
                    this.fireServiceAddEvent(vitals.service.uri);
                }
            }
        }

        private void checkServices() {
            long expireTime = System.currentTimeMillis() - MulticastDiscoveryAgent.this.heartRate * (long)MulticastDiscoveryAgent.this.maxMissedHeartbeats;
            for (ServiceVitals serviceVitals : this.discoveredServices.values()) {
                ServiceVitals vitals;
                if (serviceVitals.getLastHeartbeat() >= expireTime || MulticastDiscoveryAgent.this.isSelf(serviceVitals.service) || (vitals = this.discoveredServices.remove(serviceVitals.service.uriString)) == null || vitals.isDead()) continue;
                this.fireServiceRemovedEvent(vitals.service.uri);
            }
        }

        private void fireServiceRemovedEvent(final URI uri) {
            if (this.discoveryListener != null) {
                final DiscoveryListener discoveryListener = this.discoveryListener;
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (discoveryListener != null) {
                            discoveryListener.serviceRemoved(uri);
                        }
                    }
                });
            }
        }

        private void fireServiceAddEvent(final URI uri) {
            if (this.discoveryListener != null) {
                final DiscoveryListener discoveryListener = this.discoveryListener;
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (discoveryListener != null) {
                            discoveryListener.serviceAdded(uri);
                        }
                    }
                });
            }
        }

        public void reportFailed(URI serviceUri) {
            Service service = new Service(serviceUri);
            ServiceVitals serviceVitals = this.discoveredServices.get(service.uriString);
            if (serviceVitals != null && serviceVitals.pronounceDead()) {
                this.fireServiceRemovedEvent(service.uri);
            }
        }
    }

    private class ServiceVitals {
        private final Service service;
        private long lastHeartBeat;
        private long recoveryTime;
        private int failureCount;
        private boolean dead;

        public ServiceVitals(Service service) {
            this.service = service;
            this.lastHeartBeat = System.currentTimeMillis();
        }

        public synchronized void heartbeat() {
            this.lastHeartBeat = System.currentTimeMillis();
            if (!this.dead && this.failureCount > 0 && this.lastHeartBeat - this.recoveryTime > 60000L) {
                if (log.isDebugEnabled()) {
                    log.debug("I now think that the " + this.service + " service has recovered.");
                }
                this.failureCount = 0;
                this.recoveryTime = 0L;
            }
        }

        public synchronized long getLastHeartbeat() {
            return this.lastHeartBeat;
        }

        public synchronized boolean pronounceDead() {
            if (!this.dead) {
                long reconnectDelay;
                this.dead = true;
                ++this.failureCount;
                if (MulticastDiscoveryAgent.this.useExponentialBackOff) {
                    reconnectDelay = (long)Math.pow(MulticastDiscoveryAgent.this.backOffMultiplier, this.failureCount);
                    if (reconnectDelay > MulticastDiscoveryAgent.this.maxReconnectDelay) {
                        reconnectDelay = MulticastDiscoveryAgent.this.maxReconnectDelay;
                    }
                } else {
                    reconnectDelay = MulticastDiscoveryAgent.this.initialReconnectDelay;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Remote failure of " + this.service + " while still receiving multicast advertisements.  " + "Advertising events will be suppressed for " + reconnectDelay + " ms, the current failure count is: " + this.failureCount);
                }
                this.recoveryTime = System.currentTimeMillis() + reconnectDelay;
                return true;
            }
            return false;
        }

        public synchronized boolean doRecovery() {
            if (!this.dead) {
                return false;
            }
            if (MulticastDiscoveryAgent.this.maxReconnectAttempts > 0 && this.failureCount > MulticastDiscoveryAgent.this.maxReconnectAttempts) {
                if (log.isDebugEnabled()) {
                    log.debug("Max reconnect attempts of the " + this.service + " service has been reached.");
                }
                return false;
            }
            if (System.currentTimeMillis() < this.recoveryTime) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("Resuming event advertisement of the " + this.service + " service.");
            }
            this.dead = false;
            return true;
        }

        public boolean isDead() {
            return this.dead;
        }
    }

    class Service {
        private final URI uri;
        private final String uriString;

        public Service(URI uri) {
            this.uri = uri;
            this.uriString = uri.toString();
        }

        public Service(String uriString) throws URISyntaxException {
            this(new URI(uriString));
        }
    }
}

