/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import java.io.File;
import java.io.IOException;
import org.apache.geronimo.farm.deployment.ClusterConfigurationStore;
import org.apache.geronimo.farm.deployment.DirectoryPackager;
import org.apache.geronimo.farm.deployment.ZipDirectoryPackager;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.IOUtil;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;

public class BasicClusterConfigurationStore
implements ClusterConfigurationStore {
    private final ConfigurationStore actualConfigurationStore;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_J2EE_TYPE = "ClusterConfigurationStore";
    public static final String GBEAN_REF_CONF_STORE = "ConfigurationStore";

    public BasicClusterConfigurationStore(ConfigurationStore actualConfigurationStore) {
        if (null == actualConfigurationStore) {
            throw new IllegalArgumentException("actualConfigurationStore is required");
        }
        this.actualConfigurationStore = actualConfigurationStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(ConfigurationData configurationData, File packedConfigurationDir) throws IOException, InvalidConfigException {
        try {
            File configurationDir = this.actualConfigurationStore.createNewConfigurationDir(configurationData.getId());
            DirectoryPackager directoryPackager = this.newDirectoryPackager();
            directoryPackager.unpack(configurationDir, packedConfigurationDir);
            configurationData.setConfigurationDir(configurationDir);
            this.actualConfigurationStore.install(configurationData);
        }
        finally {
            this.deleteDir(packedConfigurationDir);
        }
    }

    public void uninstall(Artifact configId) throws NoSuchConfigException, IOException {
        this.actualConfigurationStore.uninstall(configId);
    }

    protected void deleteDir(File packedConfigurationDir) {
        IOUtil.recursiveDelete((File)packedConfigurationDir);
    }

    protected DirectoryPackager newDirectoryPackager() {
        return new ZipDirectoryPackager();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(BasicClusterConfigurationStore.class, (String)GBEAN_J2EE_TYPE);
        builder.addReference(GBEAN_REF_CONF_STORE, ConfigurationStore.class, GBEAN_REF_CONF_STORE);
        builder.addInterface(ClusterConfigurationStore.class);
        builder.setConstructor(new String[]{GBEAN_REF_CONF_STORE});
        GBEAN_INFO = builder.getBeanInfo();
    }
}

