/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.geronimo.farm.deployment.DirectoryPackager;

public class ZipDirectoryPackager
implements DirectoryPackager {
    public File pack(File configurationDir) throws IOException {
        File zippedDir = File.createTempFile(configurationDir.getName(), ".zip");
        OutputStream out = new FileOutputStream(zippedDir);
        out = new BufferedOutputStream(out);
        ZipOutputStream zos = new ZipOutputStream(out);
        this.zip(zos, configurationDir, configurationDir);
        zos.close();
        return zippedDir;
    }

    public File unpack(File packedConfigurationDir) throws IOException {
        String tmpDirAsString = System.getProperty("java.io.tmpdir");
        File targetDir = new File(new File(tmpDirAsString), packedConfigurationDir.getName() + "_unpack");
        this.unpack(targetDir, packedConfigurationDir);
        return targetDir;
    }

    public void unpack(File targetDir, File packedConfigurationDir) throws IOException {
        ZipFile zipFile = new ZipFile(packedConfigurationDir);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            int read;
            ZipEntry zipEntry = zipEntries.nextElement();
            File targetFile = new File(targetDir, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                targetFile.mkdirs();
                continue;
            }
            targetFile.getParentFile().mkdirs();
            targetFile.createNewFile();
            OutputStream out = new FileOutputStream(targetFile);
            out = new BufferedOutputStream(out);
            InputStream in = zipFile.getInputStream(zipEntry);
            byte[] buffer = new byte[1024];
            while (-1 != (read = in.read(buffer))) {
                out.write(buffer, 0, read);
            }
            in.close();
            out.close();
        }
    }

    protected void zip(ZipOutputStream zos, File configurationDir, File nestedFile) throws IOException {
        if (nestedFile.isDirectory()) {
            File[] nestedFiles = nestedFile.listFiles();
            for (int i = 0; i < nestedFiles.length; ++i) {
                this.zip(zos, configurationDir, nestedFiles[i]);
            }
        } else {
            int read;
            String nestedFilePath = nestedFile.getAbsolutePath();
            String zipEntryName = nestedFilePath.substring(configurationDir.getAbsolutePath().length() + 1, nestedFilePath.length());
            ZipEntry zipEntry = new ZipEntry(zipEntryName);
            zos.putNextEntry(zipEntry);
            InputStream in = new FileInputStream(nestedFile);
            in = new BufferedInputStream(in);
            byte[] buffer = new byte[1024];
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
            zos.closeEntry();
        }
    }
}

