/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.farm.config.ExtendedJMXConnectorInfo;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.jmx.KernelDelegate;

public class BasicNodeInfo
implements NodeInfo {
    private final String name;
    private final ExtendedJMXConnectorInfo connectorInfo;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;
    public static final String GBEAN_J2EE_TYPE = "NodeInfo";
    public static final String GBEAN_ATTR_KERNEL = "kernel";
    public static final String GBEAN_ATTR_NODE_NAME = "name";
    public static final String GBEAN_ATTR_EXT_JMX_CONN_INFO = "extendedJMXConnectorInfo";

    public BasicNodeInfo(Kernel kernel, String name, ExtendedJMXConnectorInfo connectorInfo) {
        if (null == kernel) {
            throw new IllegalArgumentException("kernel is required");
        }
        if (null == name) {
            throw new IllegalArgumentException("name is required");
        }
        if (null == connectorInfo) {
            throw new IllegalArgumentException("connectorInfo is required");
        }
        this.kernel = kernel;
        this.name = name;
        this.connectorInfo = connectorInfo;
    }

    public String getName() {
        return this.name;
    }

    public ExtendedJMXConnectorInfo getConnectorInfo() {
        return this.connectorInfo;
    }

    public Kernel newKernel() throws IOException {
        if (this.connectorInfo.isLocal()) {
            return this.kernel;
        }
        String url = "service:jmx:rmi://" + this.connectorInfo.getHost() + "/jndi/" + this.connectorInfo.getProtocol() + "://" + this.connectorInfo.getHost() + ":" + this.connectorInfo.getPort() + "/" + this.connectorInfo.getUrlPath();
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        environment.put("jmx.remote.credentials", new String[]{this.connectorInfo.getUsername(), this.connectorInfo.getPassword()});
        return this.newKernel(url, environment);
    }

    protected Kernel newKernel(String url, Map environment) throws IOException {
        JMXConnector jmxConnector = JMXConnectorFactory.connect(new JMXServiceURL(url), environment);
        MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
        return new KernelDelegate(mbServerConnection);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder builder = GBeanInfoBuilder.createStatic(BasicNodeInfo.class, (String)GBEAN_J2EE_TYPE);
        builder.addAttribute(GBEAN_ATTR_KERNEL, Kernel.class, false);
        builder.addAttribute(GBEAN_ATTR_NODE_NAME, String.class, true);
        builder.addAttribute(GBEAN_ATTR_EXT_JMX_CONN_INFO, ExtendedJMXConnectorInfo.class, true);
        builder.addInterface(NodeInfo.class);
        builder.setConstructor(new String[]{GBEAN_ATTR_KERNEL, GBEAN_ATTR_NODE_NAME, GBEAN_ATTR_EXT_JMX_CONN_INFO});
        GBEAN_INFO = builder.getBeanInfo();
    }
}

