/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class URLType {
    public static final String MANIFEST_LOCATION = "META-INF/MANIFEST.MF";
    public static final URLType RESOURCE = new URLType("RESOURCE");
    public static final URLType COLLECTION = new URLType("COLLECTION");
    public static final URLType PACKED_ARCHIVE = new URLType("PACKED_ARCHIVE");
    public static final URLType UNPACKED_ARCHIVE = new URLType("UNPACKED_ARCHIVE");
    private final String desc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLType getType(File file) throws IOException {
        if (file.isDirectory()) {
            if (new File(file, MANIFEST_LOCATION).exists()) {
                return UNPACKED_ARCHIVE;
            }
            return COLLECTION;
        }
        try {
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                jar.getManifest();
            }
            finally {
                if (jar != null) {
                    jar.close();
                }
            }
            return PACKED_ARCHIVE;
        }
        catch (ZipException e) {
            return RESOURCE;
        }
    }

    public static URLType getType(URL url) throws IOException {
        if (url.toString().endsWith("/")) {
            URL metaInfURL = new URL(url, MANIFEST_LOCATION);
            URLConnection urlConnection = metaInfURL.openConnection();
            urlConnection.connect();
            try {
                InputStream is = urlConnection.getInputStream();
                is.close();
                return UNPACKED_ARCHIVE;
            }
            catch (IOException e) {
                return COLLECTION;
            }
        }
        URL jarURL = new URL("jar:" + url.toString() + "!/");
        JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
        try {
            jarConnection.getManifest();
            return PACKED_ARCHIVE;
        }
        catch (ZipException e) {
            return RESOURCE;
        }
    }

    private URLType(String desc) {
        this.desc = desc;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this.desc;
    }
}

