/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.deployment.ModuleConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisconnectedDeploymentManager
implements DeploymentManager {
    private final Collection<ModuleConfigurer> moduleConfigurers;

    public DisconnectedDeploymentManager(Collection<ModuleConfigurer> moduleConfigurers) {
        if (null == moduleConfigurers) {
            throw new IllegalArgumentException("moduleConfigurers is required");
        }
        this.moduleConfigurers = moduleConfigurers;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        if (dObj == null) {
            throw new NullPointerException("No deployable object supplied to configure");
        }
        ModuleConfigurer configurer = null;
        for (ModuleConfigurer moduleConfigurer : this.moduleConfigurers) {
            if (moduleConfigurer.getModuleType() != dObj.getType()) continue;
            configurer = moduleConfigurer;
            break;
        }
        if (configurer == null) {
            throw new InvalidModuleException("No configurer for module type: " + dObj.getType() + " registered");
        }
        return configurer.createConfiguration(dObj);
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{this.getDefaultLocale()};
    }

    public Locale getCurrentLocale() {
        return this.getDefaultLocale();
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public boolean isLocaleSupported(Locale locale) {
        return this.getDefaultLocale().equals(locale);
    }

    public void setLocale(Locale locale) {
        if (this.isLocaleSupported(locale)) {
            throw new UnsupportedOperationException("Unsupported Locale");
        }
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return DConfigBeanVersionType.V1_4.equals(version);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        if (!this.isDConfigBeanVersionSupported(version)) {
            throw new DConfigBeanVersionUnsupportedException("Version not supported " + version);
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targets) throws TargetException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targets) throws TargetException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targets) throws TargetException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject distribute(Target[] targets, File file, File file1) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject distribute(Target[] targets, InputStream inputStream, InputStream inputStream1) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject distribute(Target[] targets, ModuleType moduleType, InputStream inputStream, InputStream inputStream1) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDs) throws IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, File file, File file1) throws UnsupportedOperationException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, InputStream inputStream, InputStream inputStream1) throws UnsupportedOperationException, IllegalStateException {
        throw new IllegalStateException("Disconnected");
    }

    public void release() {
        throw new IllegalStateException("Disconnected");
    }
}

