/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.deployment;

import java.io.File;
import java.io.IOException;
import org.apache.geronimo.farm.deployment.ClusterConfigurationStore;
import org.apache.geronimo.farm.deployment.DirectoryPackager;
import org.apache.geronimo.farm.deployment.ZipDirectoryPackager;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.FileUtils;

@GBean(j2eeType="ClusterConfigurationStore")
public class BasicClusterConfigurationStore
implements ClusterConfigurationStore {
    private final ConfigurationStore actualConfigurationStore;
    public static final String GBEAN_J2EE_TYPE = "ClusterConfigurationStore";
    public static final String GBEAN_REF_CONF_STORE = "ConfigurationStore";

    public BasicClusterConfigurationStore(@ParamReference(name="ConfigurationStore", namingType="ConfigurationStore") ConfigurationStore actualConfigurationStore) {
        if (null == actualConfigurationStore) {
            throw new IllegalArgumentException("actualConfigurationStore is required");
        }
        this.actualConfigurationStore = actualConfigurationStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(ConfigurationData configurationData, File packedConfigurationDir) throws IOException, InvalidConfigException {
        try {
            File configurationDir = this.actualConfigurationStore.createNewConfigurationDir(configurationData.getId());
            DirectoryPackager directoryPackager = this.newDirectoryPackager();
            directoryPackager.unpack(configurationDir, packedConfigurationDir);
            configurationData.setConfigurationDir(configurationDir);
            this.actualConfigurationStore.install(configurationData);
        }
        finally {
            this.deleteDir(packedConfigurationDir);
        }
    }

    @Override
    public void uninstall(Artifact configId) throws NoSuchConfigException, IOException {
        this.actualConfigurationStore.uninstall(configId);
    }

    protected void deleteDir(File packedConfigurationDir) {
        FileUtils.recursiveDelete((File)packedConfigurationDir);
    }

    protected DirectoryPackager newDirectoryPackager() {
        return new ZipDirectoryPackager();
    }
}

