/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.client;

import java.net.URI;
import java.util.Map;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.javaee.HandlerChainsType;
import org.apache.geronimo.cxf.CXFHandlerResolver;
import org.apache.geronimo.cxf.CXFWebServiceContainer;
import org.apache.geronimo.cxf.client.SAAJInterceptor;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.jaxws.HandlerChainsUtils;
import org.apache.geronimo.jaxws.JAXWSAnnotationProcessor;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.annotations.AnnotationProcessor;
import org.apache.geronimo.jaxws.client.EndpointInfo;
import org.apache.geronimo.jaxws.client.JAXWSServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFServiceReference
extends JAXWSServiceReference {
    private static final Log LOG = LogFactory.getLog(CXFServiceReference.class);

    public CXFServiceReference(String serviceClassName, String referenceClassName, URI wsdlURI, QName serviceQName, AbstractName name, String handlerChainsXML, Map<Object, EndpointInfo> seiInfoMap) {
        super(handlerChainsXML, seiInfoMap, name, serviceQName, wsdlURI, referenceClassName, serviceClassName);
    }

    public Object getContent() throws NamingException {
        Bus bus = CXFWebServiceContainer.getDefaultBus();
        BusFactory.setThreadDefaultBus((Bus)bus);
        Object reference = super.getContent();
        SAAJInterceptor.registerInterceptors();
        return reference;
    }

    protected HandlerChainsType getHandlerChains() {
        try {
            return (HandlerChainsType)HandlerChainsUtils.toHandlerChains((String)this.handlerChainsXML, HandlerChainsType.class);
        }
        catch (JAXBException e) {
            LOG.warn((Object)"Failed to deserialize handler chains", (Throwable)e);
            return null;
        }
    }

    protected HandlerResolver getHandlerResolver(Class serviceClass) {
        JAXWSAnnotationProcessor annotationProcessor = new JAXWSAnnotationProcessor(new JNDIResolver(), (WebServiceContext)new WebServiceContextImpl());
        CXFHandlerResolver handlerResolver = new CXFHandlerResolver(this.classLoader, serviceClass, this.getHandlerChains(), (AnnotationProcessor)annotationProcessor);
        return handlerResolver;
    }
}

