/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.javaee.HandlerChainsType;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.geronimo.cxf.CXFHandlerResolver;
import org.apache.geronimo.jaxws.annotations.AnnotationException;
import org.apache.geronimo.jaxws.annotations.AnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CXFEndpoint
extends javax.xml.ws.Endpoint {
    protected Bus bus;
    protected Object implementor;
    protected Server server;
    protected Service service;
    protected JaxWsImplementorInfo implInfo;
    protected JaxWsServiceFactoryBean serviceFactory;
    protected org.apache.geronimo.jaxws.PortInfo portInfo;
    protected AnnotationProcessor annotationProcessor;

    public CXFEndpoint(Bus bus, Object implementor) {
        this.bus = bus;
        this.implementor = implementor;
        this.portInfo = (org.apache.geronimo.jaxws.PortInfo)bus.getExtension(org.apache.geronimo.jaxws.PortInfo.class);
    }

    protected URL getWsdlURL(URL configurationBaseUrl, String wsdlFile) {
        URL wsdlURL;
        block5: {
            wsdlURL = null;
            if (wsdlFile != null && wsdlFile.trim().length() > 0) {
                wsdlFile = wsdlFile.trim();
                try {
                    wsdlURL = new URL(wsdlFile);
                }
                catch (MalformedURLException e) {
                    wsdlURL = this.getImplementorClass().getResource("/" + wsdlFile);
                    if (wsdlURL != null || configurationBaseUrl == null) break block5;
                    try {
                        wsdlURL = new URL(configurationBaseUrl, wsdlFile);
                    }
                    catch (MalformedURLException ee) {
                        // empty catch block
                    }
                }
            }
        }
        return wsdlURL;
    }

    protected Class getImplementorClass() {
        return this.implementor.getClass();
    }

    protected Endpoint getEndpoint() {
        return this.getServer().getEndpoint();
    }

    public ServerImpl getServer() {
        return (ServerImpl)this.server;
    }

    public Binding getBinding() {
        return ((JaxWsEndpointImpl)this.getEndpoint()).getJaxwsBinding();
    }

    public void setExecutor(Executor executor) {
        this.service.setExecutor(executor);
    }

    public Executor getExecutor() {
        return this.service.getExecutor();
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public List<Source> getMetadata() {
        return null;
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public boolean isPublished() {
        return this.server != null;
    }

    public void publish(Object arg0) {
    }

    public void publish(String address) {
        this.doPublish(address);
    }

    public void setMetadata(List<Source> arg0) {
    }

    public void setProperties(Map<String, Object> arg0) {
    }

    protected void doPublish(String address) {
        GeronimoJaxWsServerFactoryBean svrFactory = new GeronimoJaxWsServerFactoryBean();
        svrFactory.setBus(this.bus);
        svrFactory.setAddress(address);
        svrFactory.setServiceFactory((ReflectionServiceFactoryBean)this.serviceFactory);
        svrFactory.setStart(false);
        svrFactory.setServiceBean(this.implementor);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.implInfo.getBindingType())) {
            svrFactory.setTransportId("http://cxf.apache.org/bindings/xformat");
        }
        this.server = svrFactory.create();
        this.init();
        Endpoint endpoint = this.getEndpoint();
        if (this.getBinding() instanceof SOAPBinding) {
            ((SOAPBinding)this.getBinding()).setMTOMEnabled(this.portInfo.isMTOMEnabled());
        }
        this.server.start();
    }

    protected void init() {
    }

    protected void initHandlers() throws Exception {
        HandlerChainsType handlerChains = (HandlerChainsType)this.portInfo.getHandlers(HandlerChainsType.class);
        CXFHandlerResolver handlerResolver = new CXFHandlerResolver(this.getImplementorClass().getClassLoader(), this.getImplementorClass(), handlerChains, null);
        PortInfoImpl portInfo = new PortInfoImpl(this.implInfo.getBindingType(), this.serviceFactory.getEndpointName(), this.service.getName());
        List<Handler> chain = handlerResolver.getHandlerChain((PortInfo)portInfo);
        this.getBinding().setHandlerChain(chain);
    }

    protected void injectResources(Object instance) throws AnnotationException {
        this.annotationProcessor.processAnnotations(instance);
        this.annotationProcessor.invokePostConstruct(instance);
    }

    protected void injectHandlers() {
        List handlers = this.getBinding().getHandlerChain();
        try {
            for (Handler handler : handlers) {
                this.injectResources(handler);
            }
        }
        catch (AnnotationException e) {
            throw new WebServiceException("Handler annotation failed", (Throwable)e);
        }
    }

    protected void destroyHandlers() {
        if (this.annotationProcessor != null) {
            List handlers = this.getBinding().getHandlerChain();
            for (Handler handler : handlers) {
                this.annotationProcessor.invokePreDestroy((Object)handler);
            }
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private static class GeronimoJaxWsServerFactoryBean
    extends JaxWsServerFactoryBean {
        public GeronimoJaxWsServerFactoryBean() {
            this.doInit = false;
        }
    }
}

