/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.wsdl.WsdlGenerator;
import org.apache.geronimo.jaxws.wsdl.WsdlGeneratorOptions;
import org.apache.geronimo.jaxws.wsdl.WsdlGeneratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFWsdlGenerator
implements WsdlGenerator {
    private ClassLoader classLoader;
    public static final GBeanInfo GBEAN_INFO;

    public CXFWsdlGenerator(AbstractName abstractName, ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String generateWsdl(Module module, String serviceClass, DeploymentContext context, WsdlGeneratorOptions options) throws DeploymentException {
        boolean result;
        File baseDir;
        File moduleBase = module.getEarContext().getInPlaceConfigurationDir();
        if (moduleBase == null) {
            moduleBase = module.getEarContext().getBaseDir();
        }
        File moduleBaseDir = moduleBase.isFile() ? moduleBase.getParentFile() : moduleBase;
        try {
            baseDir = WsdlGeneratorUtils.createTempDirectory((File)moduleBaseDir);
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        LinkedHashSet jars = new LinkedHashSet();
        WsdlGeneratorUtils.getClassLoaderClasspath((ClassLoader)this.classLoader, jars);
        try {
            WsdlGeneratorUtils.getModuleClasspath((Module)module, (DeploymentContext)context, jars);
        }
        catch (Exception e) {
            throw new DeploymentException("WSDL generation failed: unable to determine module classpath", (Throwable)e);
        }
        String classpath = WsdlGeneratorUtils.buildClasspath(jars);
        List<String> cmd = this.buildArguments(serviceClass, classpath, baseDir, options);
        try {
            result = WsdlGeneratorUtils.execJava(cmd, (long)options.getForkTimeout());
        }
        catch (Exception e) {
            throw new DeploymentException("WSDL generation failed", (Throwable)e);
        }
        if (result) {
            String serviceName = CXFWsdlGenerator.getLocalPart(options.getWsdlService());
            File wsdlFile = WsdlGeneratorUtils.findWsdlFile((File)baseDir, (String)serviceName);
            if (wsdlFile == null) {
                throw new DeploymentException("Unable to find the service wsdl file");
            }
            if (options.getAddToClassPath()) {
                try {
                    context.getConfiguration().addToClassPath(baseDir.getName());
                }
                catch (IOException e) {
                    throw new DeploymentException("Failed to update module classpath");
                }
            }
            return WsdlGeneratorUtils.getRelativeNameOrURL((File)moduleBase, (File)wsdlFile);
        }
        throw new DeploymentException("WSDL generation failed");
    }

    private List<String> buildArguments(String sei, String classpath, File moduleBaseDir, WsdlGeneratorOptions options) {
        String tns;
        String portName;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-classpath");
        arguments.add(classpath);
        arguments.add("-Dorg.apache.cxf.nofastinfoset=true");
        arguments.add("org.apache.cxf.tools.java2ws.JavaToWS");
        arguments.add("-d");
        arguments.add(moduleBaseDir.getAbsolutePath());
        arguments.add("-classdir");
        arguments.add(moduleBaseDir.getAbsolutePath());
        arguments.add("-server");
        arguments.add("-wsdl");
        arguments.add("-wrapperbean");
        arguments.add("-frontend");
        arguments.add("jaxws");
        String serviceName = CXFWsdlGenerator.getLocalPart(options.getWsdlService());
        if (serviceName != null) {
            arguments.add("-servicename");
            arguments.add(serviceName);
        }
        if ((portName = CXFWsdlGenerator.getLocalPart(options.getWsdlPort())) != null) {
            arguments.add("-port");
            arguments.add(portName);
        }
        if ((tns = CXFWsdlGenerator.getNamespace(options.getWsdlService(), options.getWsdlPort())) != null) {
            arguments.add("-t");
            arguments.add(tns);
        }
        arguments.add(sei);
        return arguments;
    }

    private static String getLocalPart(QName name) {
        return name == null ? null : name.getLocalPart();
    }

    private static String getNamespace(QName service, QName port) {
        String ns = null;
        if (service != null && (ns = service.getNamespaceURI()).length() > 0) {
            return ns;
        }
        if (port != null && (ns = port.getNamespaceURI()).length() > 0) {
            return ns;
        }
        return ns;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(CXFWsdlGenerator.class, (String)"GBean");
        infoBuilder.addInterface(WsdlGenerator.class);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("abstractName", AbstractName.class, false);
        infoBuilder.setConstructor(new String[]{"abstractName", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

