/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.builder;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.cxf.client.CXFServiceReference;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.builder.EndpointInfoBuilder;
import org.apache.geronimo.jaxws.builder.JAXWSServiceRefBuilder;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee.PortComponentRefType;
import org.apache.geronimo.xbeans.javaee.ServiceRefHandlerChainsType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFServiceRefBuilder
extends JAXWSServiceRefBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CXFServiceRefBuilder.class);
    public static final GBeanInfo GBEAN_INFO;

    public CXFServiceRefBuilder(Environment defaultEnvironment, String[] eeNamespaces) {
        super(defaultEnvironment, eeNamespaces);
    }

    public Object createService(ServiceRefType serviceRef, GerServiceRefType gerServiceRef, Module module, ClassLoader cl, Class serviceInterface, QName serviceQName, URI wsdlURI, Class serviceReference, Map<Class, PortComponentRefType> portComponentRefMap) throws DeploymentException {
        EndpointInfoBuilder builder = new EndpointInfoBuilder(serviceInterface, gerServiceRef, portComponentRefMap, module, cl, wsdlURI, serviceQName);
        builder.build();
        wsdlURI = builder.getWsdlURI();
        serviceQName = builder.getServiceQName();
        Map seiInfoMap = builder.getEndpointInfo();
        String handlerChainsXML = null;
        try {
            handlerChainsXML = CXFServiceRefBuilder.getHandlerChainAsString((ServiceRefHandlerChainsType)serviceRef.getHandlerChains());
        }
        catch (IOException e) {
            LOG.warn("Failed to serialize handler chains", (Throwable)e);
        }
        String serviceReferenceName = serviceReference == null ? null : serviceReference.getName();
        return new CXFServiceReference(serviceInterface.getName(), serviceReferenceName, wsdlURI, serviceQName, module.getModuleName(), handlerChainsXML, seiInfoMap);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(CXFServiceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(ServiceRefBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

