/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.naming.ResourceSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseInitializationGBean {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitializationGBean.class);
    public static final GBeanInfo GBEAN_INFO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseInitializationGBean(String testSQL, String path, ResourceSource<ResourceException> cfSource, ClassLoader classLoader) throws Exception {
        block19: {
            DataSource ds = (DataSource)cfSource.$getResource();
            Connection c = ds.getConnection();
            try {
                Statement s = c.createStatement();
                try {
                    boolean pass = true;
                    if (testSQL != null && !testSQL.trim().equals("")) {
                        ResultSet rs = null;
                        try {
                            rs = s.executeQuery(testSQL);
                            pass = !rs.next();
                        }
                        catch (SQLException e) {
                            log.info("Exception running test query, executing script: " + e.getMessage());
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    if (pass) {
                        log.debug("Executing script: " + path);
                        URL sourceURL = classLoader.getResource(path);
                        InputStream ins = sourceURL.openStream();
                        BufferedReader r = new BufferedReader(new InputStreamReader(ins));
                        try {
                            String line;
                            StringBuffer buf = new StringBuffer();
                            while ((line = r.readLine()) != null) {
                                if ((line = line.trim()).startsWith("--") || line.length() <= 0) continue;
                                buf.append(line).append(" ");
                                if (!line.endsWith(";")) continue;
                                int size = buf.length();
                                buf.delete(size - 2, size - 1);
                                String sql = buf.toString();
                                s.execute(sql);
                                buf = new StringBuffer();
                            }
                            break block19;
                        }
                        catch (Exception ex) {
                            log.error(ex.getMessage());
                            break block19;
                        }
                        finally {
                            r.close();
                        }
                    }
                    log.debug("Script did not run");
                }
                catch (SQLException e) {
                    log.error(e.getMessage());
                }
                finally {
                    s.close();
                }
            }
            finally {
                c.close();
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(DatabaseInitializationGBean.class, (String)"GBean");
        infoBuilder.addAttribute("testSQL", String.class, false);
        infoBuilder.addAttribute("path", String.class, true);
        infoBuilder.addReference("DataSource", ResourceSource.class, "JCAManagedConnectionFactory");
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.setConstructor(new String[]{"testSQL", "path", "DataSource", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

