/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.ResourceAdapterWrapper;
import org.apache.geronimo.connector.outbound.ConnectionManagerContainer;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.DynamicGBeanDelegate;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.JCAManagedConnectionFactory;
import org.apache.geronimo.naming.ResourceSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnectionFactoryWrapper
implements GBeanLifecycle,
DynamicGBean,
JCAManagedConnectionFactory,
ResourceSource<ResourceException> {
    private static final Log log = LogFactory.getLog(ManagedConnectionFactoryWrapper.class);
    private final String managedConnectionFactoryClass;
    private final String connectionFactoryInterface;
    private final String[] implementedInterfaces;
    private final String connectionFactoryImplClass;
    private final String connectionInterface;
    private final String connectionImplClass;
    private final LinkedHashSet<Class> allImplementedInterfaces = new LinkedHashSet();
    private final ResourceAdapterWrapper resourceAdapterWrapper;
    private final ConnectionManagerContainer connectionManagerContainer;
    private ManagedConnectionFactory managedConnectionFactory;
    private DynamicGBeanDelegate delegate;
    private boolean registered = false;
    private final Kernel kernel;
    private final AbstractName abstractName;
    private final String objectName;
    private final ClassLoader classLoader;

    public ManagedConnectionFactoryWrapper() {
        this.managedConnectionFactoryClass = null;
        this.connectionFactoryInterface = null;
        this.implementedInterfaces = null;
        this.connectionFactoryImplClass = null;
        this.connectionInterface = null;
        this.connectionImplClass = null;
        this.kernel = null;
        this.abstractName = null;
        this.objectName = null;
        this.classLoader = null;
        this.resourceAdapterWrapper = null;
        this.connectionManagerContainer = null;
    }

    public ManagedConnectionFactoryWrapper(String managedConnectionFactoryClass, String connectionFactoryInterface, String[] implementedInterfaces, String connectionFactoryImplClass, String connectionInterface, String connectionImplClass, ResourceAdapterWrapper resourceAdapterWrapper, ConnectionManagerContainer connectionManagerContainer, Kernel kernel, AbstractName abstractName, String objectName, ClassLoader cl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
        this.connectionFactoryInterface = connectionFactoryInterface;
        this.implementedInterfaces = implementedInterfaces;
        this.connectionFactoryImplClass = connectionFactoryImplClass;
        this.connectionInterface = connectionInterface;
        this.connectionImplClass = connectionImplClass;
        this.allImplementedInterfaces.add(cl.loadClass(connectionFactoryInterface));
        for (String interfaceName : implementedInterfaces) {
            this.allImplementedInterfaces.add(cl.loadClass(interfaceName));
        }
        this.resourceAdapterWrapper = resourceAdapterWrapper;
        this.connectionManagerContainer = connectionManagerContainer;
        this.classLoader = cl;
        Class<?> clazz = cl.loadClass(managedConnectionFactoryClass);
        this.managedConnectionFactory = (ManagedConnectionFactory)clazz.newInstance();
        this.delegate = new DynamicGBeanDelegate();
        this.delegate.addAll((Object)this.managedConnectionFactory);
        this.kernel = kernel;
        this.abstractName = abstractName;
        this.objectName = objectName;
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public String[] getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public ResourceAdapterWrapper getResourceAdapterWrapper() {
        return this.resourceAdapterWrapper;
    }

    public Object getConnectionManagerContainer() {
        return this.connectionManagerContainer;
    }

    public void doStart() throws Exception {
        if (!this.registered && this.managedConnectionFactory instanceof ResourceAdapterAssociation) {
            if (this.resourceAdapterWrapper == null) {
                throw new IllegalStateException("Managed connection factory expects to be registered with a ResourceAdapter, but there is no ResourceAdapter");
            }
            this.resourceAdapterWrapper.registerResourceAdapterAssociation((ResourceAdapterAssociation)this.managedConnectionFactory);
            this.registered = true;
            log.debug((Object)("Registered managedConnectionFactory with ResourceAdapter " + this.resourceAdapterWrapper.toString()));
        }
        this.connectionManagerContainer.doRecovery(this.managedConnectionFactory);
    }

    public void doStop() {
    }

    public void doFail() {
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            Object object = this.delegate.getAttribute(name);
            return object;
        }
        finally {
            thread.setContextClassLoader(oldTCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldTCL = thread.getContextClassLoader();
        thread.setContextClassLoader(this.classLoader);
        try {
            if (value != null && value instanceof Properties) {
                Properties ps = (Properties)value;
                if (!ps.isEmpty()) {
                    StringBuilder s = new StringBuilder();
                    for (Object o : ps.keySet()) {
                        String k = (String)o;
                        String v = ps.getProperty(k);
                        s = s.append(k).append("=").append(v).append(",");
                    }
                    this.delegate.setAttribute(name, (Object)s.toString());
                    log.debug((Object)("Setting " + name + " value " + s));
                }
            } else {
                this.delegate.setAttribute(name, value);
                log.debug((Object)("Setting " + name + " value " + value));
            }
        }
        finally {
            thread.setContextClassLoader(oldTCL);
        }
    }

    public Object invoke(String name, Object[] arguments, String[] types) throws Exception {
        return null;
    }

    public Object getConnectionFactory() throws ResourceException {
        return this.$getConnectionFactory();
    }

    public Object $getResource() throws ResourceException {
        return this.$getConnectionFactory();
    }

    public Object $getConnectionFactory() throws ResourceException {
        Object connectionFactory = this.connectionManagerContainer.createConnectionFactory(this.managedConnectionFactory);
        for (Class intf : this.allImplementedInterfaces) {
            if (intf.isAssignableFrom(connectionFactory.getClass())) continue;
            throw new ResourceException("ConnectionFactory does not implement expected interface: " + intf.getName());
        }
        return connectionFactory;
    }

    public ManagedConnectionFactory $getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public Map<String, Class> getConfigProperties() {
        String[] props = this.delegate.getProperties();
        HashMap<String, Class> map = new HashMap<String, Class>();
        for (String prop : props) {
            if (prop.equals("logWriter")) continue;
            map.put(prop, this.delegate.getPropertyType(prop));
        }
        return map;
    }

    public void setConfigProperty(String property, Object value) throws Exception {
        Class cls = this.delegate.getPropertyType(property);
        if (value != null && value instanceof String && !cls.getName().equals("java.lang.String")) {
            if (cls.isPrimitive()) {
                if (cls.equals(Integer.TYPE)) {
                    cls = Integer.class;
                } else if (cls.equals(Boolean.TYPE)) {
                    cls = Boolean.class;
                } else if (cls.equals(Float.TYPE)) {
                    cls = Float.class;
                } else if (cls.equals(Double.TYPE)) {
                    cls = Double.class;
                } else if (cls.equals(Long.TYPE)) {
                    cls = Long.class;
                } else if (cls.equals(Short.TYPE)) {
                    cls = Short.class;
                } else if (cls.equals(Byte.TYPE)) {
                    cls = Byte.class;
                } else if (cls.equals(Character.TYPE)) {
                    cls = Character.class;
                }
            }
            Constructor con = cls.getConstructor(String.class);
            value = con.newInstance(value);
        }
        this.kernel.setAttribute(this.abstractName, property, value);
    }

    public Object getConfigProperty(String property) throws Exception {
        return this.delegate.getAttribute(property);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }
}

