/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.connectiontracking;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;

public class ConnectionTrackingCoordinator
implements TrackedConnectionAssociator,
ConnectionTracker {
    private static final Log log = LogFactory.getLog((String)ConnectionTrackingCoordinator.class.getName());
    private final ThreadLocal currentInstanceContexts = new ThreadLocal();

    public ConnectorInstanceContext enter(ConnectorInstanceContext newConnectorInstanceContext) throws ResourceException {
        ConnectorInstanceContext oldConnectorInstanceContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        this.currentInstanceContexts.set(newConnectorInstanceContext);
        this.notifyConnections(newConnectorInstanceContext);
        return oldConnectorInstanceContext;
    }

    private void notifyConnections(ConnectorInstanceContext oldConnectorInstanceContext) throws ResourceException {
        Map connectionManagerToManagedConnectionInfoMap = oldConnectorInstanceContext.getConnectionManagerMap();
        Iterator i = connectionManagerToManagedConnectionInfoMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ConnectionTrackingInterceptor mcci = (ConnectionTrackingInterceptor)entry.getKey();
            Set connections = (Set)entry.getValue();
            mcci.enter(connections);
        }
    }

    public void newTransaction() throws ResourceException {
        ConnectorInstanceContext oldConnectorInstanceContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (oldConnectorInstanceContext == null) {
            return;
        }
        this.notifyConnections(oldConnectorInstanceContext);
    }

    public void exit(ConnectorInstanceContext reenteringConnectorInstanceContext) throws ResourceException {
        ConnectorInstanceContext oldConnectorInstanceContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        Map resources = oldConnectorInstanceContext.getConnectionManagerMap();
        Iterator i = resources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ConnectionTrackingInterceptor mcci = (ConnectionTrackingInterceptor)entry.getKey();
            Set connections = (Set)entry.getValue();
            mcci.exit(connections);
            if (!connections.isEmpty()) continue;
            i.remove();
        }
        this.currentInstanceContexts.set(reenteringConnectorInstanceContext);
    }

    public void handleObtained(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo) {
        ConnectorInstanceContext connectorInstanceContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (connectorInstanceContext == null) {
            return;
        }
        Map resources = connectorInstanceContext.getConnectionManagerMap();
        HashSet<ConnectionInfo> infos = (HashSet<ConnectionInfo>)resources.get(connectionTrackingInterceptor);
        if (infos == null) {
            infos = new HashSet<ConnectionInfo>();
            resources.put(connectionTrackingInterceptor, infos);
        }
        infos.add(connectionInfo);
    }

    public void handleReleased(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo) {
        ConnectorInstanceContext connectorInstanceContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (connectorInstanceContext == null) {
            return;
        }
        Map resources = connectorInstanceContext.getConnectionManagerMap();
        Set infos = (Set)resources.get(connectionTrackingInterceptor);
        if (infos == null && log.isTraceEnabled()) {
            log.trace((Object)("No infos found for handle " + connectionInfo.getConnectionHandle() + " for MCI: " + connectionInfo.getManagedConnectionInfo() + " for MC: " + connectionInfo.getManagedConnectionInfo().getManagedConnection() + " for CTI: " + connectionTrackingInterceptor), (Throwable)new Exception("Stack Trace"));
        }
        if (connectionInfo.getConnectionHandle() == null) {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            Collection toRemove = mci.getConnectionInfos();
            infos.removeAll(toRemove);
        } else {
            infos.remove(connectionInfo);
        }
    }

    public void setEnvironment(ConnectionInfo connectionInfo, String key) {
        ConnectorInstanceContext currentConnectorInstanceContext = (ConnectorInstanceContext)this.currentInstanceContexts.get();
        if (currentConnectorInstanceContext != null) {
            Set unshareableResources = currentConnectorInstanceContext.getUnshareableResources();
            boolean unshareable = unshareableResources.contains(key);
            connectionInfo.setUnshareable(unshareable);
            Set applicationManagedSecurityResources = currentConnectorInstanceContext.getApplicationManagedSecurityResources();
            boolean applicationManagedSecurity = applicationManagedSecurityResources.contains(key);
            connectionInfo.setApplicationManagedSecurity(applicationManagedSecurity);
        }
    }
}

