/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.j2ee.deployment.CorbaGBeanNameSource;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.naming.reference.ORBReference;
import org.apache.geronimo.naming.reference.ResourceReferenceFactory;
import org.apache.geronimo.naming.reference.URLReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.javaee.DescriptionType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.ResAuthType;
import org.apache.geronimo.xbeans.javaee.ResSharingScopeType;
import org.apache.geronimo.xbeans.javaee.ResourceRefType;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.omg.CORBA.ORB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRefBuilder
extends AbstractNamingBuilder
implements ResourceEnvironmentSetter {
    private static final Logger log = LoggerFactory.getLogger(ResourceRefBuilder.class);
    private static final QName GER_RESOURCE_REF_QNAME = GerResourceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_RESOURCE_REF_QNAME_SET = QNameSet.singleton((QName)GER_RESOURCE_REF_QNAME);
    private static final String JAXR_CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactory";
    private static final String JAVAX_MAIL_SESSION_CLASS = "javax.mail.Session";
    private final QNameSet resourceRefQNameSet;
    private final Environment corbaEnvironment;
    private final SingleElementCollection corbaGBeanNameSourceCollection;
    public static final GBeanInfo GBEAN_INFO;

    public ResourceRefBuilder(Environment defaultEnvironment, Environment corbaEnvironment, String[] eeNamespaces, Collection corbaGBeanNameSourceCollection) {
        super(defaultEnvironment);
        this.resourceRefQNameSet = ResourceRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"resource-ref");
        this.corbaEnvironment = corbaEnvironment;
        this.corbaGBeanNameSourceCollection = new SingleElementCollection(corbaGBeanNameSourceCollection);
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.resourceRefQNameSet).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        if (module != null && module.getClassFinder() != null) {
            try {
                ResourceAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)ResourceRefProcessor.INSTANCE);
            }
            catch (Exception e) {
                log.warn("Unable to process @Resource annotations for module" + module.getName(), (Throwable)e);
            }
        }
        List resourceRefsUntyped = ResourceRefBuilder.convert((XmlObject[])specDD.selectChildren(this.resourceRefQNameSet), (NamespaceElementConverter)J2EE_CONVERTER, ResourceRefType.class, (SchemaType)ResourceRefType.type);
        XmlObject[] gerResourceRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_RESOURCE_REF_QNAME_SET);
        Map<String, GerResourceRefType> refMap = this.mapResourceRefs(gerResourceRefsUntyped);
        ArrayList<String> unresolvedRefs = new ArrayList<String>();
        ClassLoader cl = module.getEarContext().getClassLoader();
        for (ResourceRefType resourceRef : resourceRefsUntyped) {
            Class<?> iface;
            String name = resourceRef.getResRefName().getStringValue().trim();
            if (this.lookupJndiContextMap(componentContext, "env/" + name) != null) continue;
            this.addInjections(name, resourceRef.getInjectionTargetArray(), componentContext);
            String type = resourceRef.getResType().getStringValue().trim();
            GerResourceRefType gerResourceRef = refMap.get(name);
            log.debug("trying to resolve " + name + ", type " + type + ", resourceRef " + gerResourceRef);
            if (!refMap.containsKey(name)) {
                unresolvedRefs.add(name);
            }
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            if (iface == URL.class) {
                if (gerResourceRef == null || !gerResourceRef.isSetUrl()) {
                    throw new DeploymentException("No url supplied to resolve: " + name);
                }
                String url = gerResourceRef.getUrl().trim();
                try {
                    new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException("Could not convert " + url + " to URL", (Throwable)e);
                }
                this.getJndiContextMap(componentContext).put("env/" + name, new URLReference(url));
                unresolvedRefs.remove(name);
                continue;
            }
            if (ORB.class.isAssignableFrom(iface)) {
                CorbaGBeanNameSource corbaGBeanNameSource = (CorbaGBeanNameSource)this.corbaGBeanNameSourceCollection.getElement();
                if (corbaGBeanNameSource == null) {
                    throw new DeploymentException("No orb setup but there is a orb reference");
                }
                AbstractNameQuery corbaName = corbaGBeanNameSource.getCorbaGBeanName();
                if (corbaName == null) continue;
                Artifact[] moduleId = module.getConfigId();
                Map context = this.getJndiContextMap(componentContext);
                context.put("env/" + name, new ORBReference(moduleId, corbaName));
                unresolvedRefs.remove(name);
                EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.corbaEnvironment);
                continue;
            }
            String j2eeType = JAVAX_MAIL_SESSION_CLASS.equals(type) ? "JavaMailResource" : (JAXR_CONNECTION_FACTORY_CLASS.equals(type) ? "JAXRConnectionFactory" : "JCAManagedConnectionFactory");
            try {
                AbstractNameQuery containerId = this.getResourceContainerId(name, j2eeType, null, gerResourceRef);
                module.getEarContext().findGBean(containerId);
                ResourceReferenceFactory ref = new ResourceReferenceFactory(module.getConfigId(), containerId, iface);
                this.getJndiContextMap(componentContext).put("env/" + name, ref);
                unresolvedRefs.remove(name);
            }
            catch (GBeanNotFoundException e) {
                StringBuffer errorMessage = new StringBuffer("Unable to resolve resource reference '");
                errorMessage.append(name);
                errorMessage.append("' (");
                if (e.hasMatches()) {
                    errorMessage.append("Found multiple matching resources.  Try being more specific in a resource-ref mapping in your Geronimo deployment plan.\n");
                    for (AbstractName match : e.getMatches()) {
                        errorMessage.append(match).append("\n");
                    }
                } else if (gerResourceRef == null) {
                    errorMessage.append("Could not auto-map to resource.  Try adding a resource-ref mapping to your Geronimo deployment plan.");
                } else if (gerResourceRef.isSetResourceLink()) {
                    errorMessage.append("Could not find resource '");
                    errorMessage.append(gerResourceRef.getResourceLink());
                    errorMessage.append("'.  Perhaps it has not yet been configured, or your application does not have a dependency declared for that resource module?");
                } else {
                    errorMessage.append("Could not find the resource specified in your Geronimo deployment plan:");
                    errorMessage.append(gerResourceRef.getPattern());
                }
                errorMessage.append("\nSearch conducted in current module and dependencies:\n");
                for (Dependency dependency : module.getEnvironment().getDependencies()) {
                    errorMessage.append(dependency).append("\n");
                }
                errorMessage.append(")");
                throw new DeploymentException(errorMessage.toString());
            }
        }
        if (unresolvedRefs.size() > 0) {
            log.warn("Failed to build reference to resource reference " + unresolvedRefs + " defined in plan file, reason - corresponding entry in deployment descriptor missing.");
        }
    }

    public void setResourceEnvironment(ResourceEnvironmentBuilder builder, XmlObject[] resourceRefs, GerResourceRefType[] gerResourceRefs) throws DeploymentException {
        List resourceRefList = ResourceRefBuilder.convert((XmlObject[])resourceRefs, (NamespaceElementConverter)J2EE_CONVERTER, ResourceRefType.class, (SchemaType)ResourceRefType.type);
        Map<String, GerResourceRefType> refMap = this.mapResourceRefs((XmlObject[])gerResourceRefs);
        HashSet<AbstractNameQuery> unshareableResources = new HashSet<AbstractNameQuery>();
        HashSet<AbstractNameQuery> applicationManagedSecurityResources = new HashSet<AbstractNameQuery>();
        for (ResourceRefType resourceRefType : resourceRefList) {
            String type = resourceRefType.getResType().getStringValue().trim();
            if (URL.class.getName().equals(type) || JAVAX_MAIL_SESSION_CLASS.equals(type) || JAXR_CONNECTION_FACTORY_CLASS.equals(type)) continue;
            GerResourceRefType gerResourceRef = refMap.get(resourceRefType.getResRefName().getStringValue());
            AbstractNameQuery containerId = this.getResourceContainerId(ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)resourceRefType.getResRefName()), "JCAManagedConnectionFactory", null, gerResourceRef);
            if ("Unshareable".equals(ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)resourceRefType.getResSharingScope()))) {
                unshareableResources.add(containerId);
            }
            if (!"Application".equals(ResourceRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)resourceRefType.getResAuth()))) continue;
            applicationManagedSecurityResources.add(containerId);
        }
        builder.setUnshareableResources(unshareableResources);
        builder.setApplicationManagedSecurityResources(applicationManagedSecurityResources);
    }

    private Map<String, GerResourceRefType> mapResourceRefs(XmlObject[] refs) {
        HashMap<String, GerResourceRefType> refMap = new HashMap<String, GerResourceRefType>();
        if (refs != null) {
            for (XmlObject ref1 : refs) {
                GerResourceRefType ref = (GerResourceRefType)ref1.copy().changeType(GerResourceRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private AbstractNameQuery getResourceContainerId(String name, String type, URI moduleURI, GerResourceRefType gerResourceRef) {
        AbstractNameQuery containerId;
        String module;
        String string = module = moduleURI == null ? null : moduleURI.toString();
        if (gerResourceRef == null) {
            containerId = ResourceRefBuilder.buildAbstractNameQuery(null, (String)module, (String)name, (String)type, (String)"ResourceAdapterModule");
        } else if (gerResourceRef.isSetResourceLink()) {
            containerId = ResourceRefBuilder.buildAbstractNameQuery(null, (String)module, (String)gerResourceRef.getResourceLink().trim(), (String)type, (String)"ResourceAdapterModule");
        } else {
            GerPatternType patternType = gerResourceRef.getPattern();
            containerId = ResourceRefBuilder.buildAbstractNameQuery((GerPatternType)patternType, (String)type, (String)"ResourceAdapterModule", null);
        }
        return containerId;
    }

    public QNameSet getSpecQNameSet() {
        return this.resourceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_RESOURCE_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ResourceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("corbaEnvironment", Environment.class, true, true);
        infoBuilder.addReference("CorbaGBeanNameSource", CorbaGBeanNameSource.class);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "corbaEnvironment", "eeNamespaces", "CorbaGBeanNameSource"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    public static class ResourceRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        public static final ResourceRefProcessor INSTANCE = new ResourceRefProcessor();

        private ResourceRefProcessor() {
        }

        public boolean processResource(AnnotatedApp annotatedApp, Resource annotation, Class cls, Method method, Field field) {
            log.debug("processResource( [annotatedApp] " + annotatedApp.toString() + "," + '\n' + "[annotation] " + annotation.toString() + "," + '\n' + "[cls] " + (cls != null ? cls.getName() : null) + "," + '\n' + "[method] " + (method != null ? method.getName() : null) + "," + '\n' + "[field] " + (field != null ? field.getName() : null) + " ): Entry");
            String resourceName = ResourceRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            String resourceType = ResourceRefProcessor.getResourceType((Resource)annotation, (Method)method, (Field)field);
            if (resourceType.equals("javax.sql.DataSource") || resourceType.equals(ResourceRefBuilder.JAVAX_MAIL_SESSION_CLASS) || resourceType.equals("java.net.URL") || resourceType.equals("org.omg.CORBA.ORB") || resourceType.equals("org.omg.CORBA_2_3.ORB") || resourceType.equals("org.omg.CORBA_2_4.ORB") || resourceType.endsWith("ConnectionFactory")) {
                ResourceRefType[] resourceRefs;
                log.debug("processResource(): <resource-ref> found");
                boolean exists = false;
                for (ResourceRefType resourceRef : resourceRefs = annotatedApp.getResourceRefArray()) {
                    InjectionTargetType[] targets;
                    if (!resourceRef.getResRefName().getStringValue().trim().equals(resourceName)) continue;
                    if (!(method == null && field == null || ResourceRefProcessor.hasTarget((Method)method, (Field)field, (InjectionTargetType[])(targets = resourceRef.getInjectionTargetArray())))) {
                        ResourceRefProcessor.configureInjectionTarget((InjectionTargetType)resourceRef.addNewInjectionTarget(), (Method)method, (Field)field);
                    }
                    exists = true;
                    break;
                }
                if (!exists) {
                    try {
                        ResAuthType resAuth;
                        String descriptionAnnotation;
                        log.debug("processResource(): Does not exist in DD: " + resourceName);
                        ResourceRefType resourceRef = annotatedApp.addNewResourceRef();
                        JndiNameType resourceRefName = resourceRef.addNewResRefName();
                        resourceRefName.setStringValue(resourceName);
                        if (!resourceType.equals("")) {
                            FullyQualifiedClassType qualifiedClass = resourceRef.addNewResType();
                            qualifiedClass.setStringValue(resourceType);
                        }
                        if (method != null || field != null) {
                            InjectionTargetType injectionTarget = resourceRef.addNewInjectionTarget();
                            ResourceRefProcessor.configureInjectionTarget((InjectionTargetType)injectionTarget, (Method)method, (Field)field);
                        }
                        if (!(descriptionAnnotation = annotation.description()).equals("")) {
                            DescriptionType description = resourceRef.addNewDescription();
                            description.setStringValue(descriptionAnnotation);
                        }
                        if (annotation.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                            resAuth = resourceRef.addNewResAuth();
                            resAuth.setStringValue("Container");
                            resourceRef.setResAuth(resAuth);
                        } else if (annotation.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                            resAuth = resourceRef.addNewResAuth();
                            resAuth.setStringValue("Application");
                            resourceRef.setResAuth(resAuth);
                        }
                        ResSharingScopeType resScope = resourceRef.addNewResSharingScope();
                        resScope.setStringValue(annotation.shareable() ? "Shareable" : "Unshareable");
                        resourceRef.setResSharingScope(resScope);
                        String mappdedNameAnnotation = annotation.mappedName();
                        if (!mappdedNameAnnotation.equals("")) {
                            XsdStringType mappedName = resourceRef.addNewMappedName();
                            mappedName.setStringValue(mappdedNameAnnotation);
                            resourceRef.setMappedName(mappedName);
                        }
                    }
                    catch (Exception anyException) {
                        log.debug("ResourceRefBuilder: Exception caught while processing <resource-ref>");
                    }
                }
                return true;
            }
            return false;
        }
    }
}

