/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.j2ee.deployment.annotation.ResourceAnnotationHelper;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.ResourceReference;
import org.apache.geronimo.naming.reference.UserTransactionReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.javaee.DescriptionType;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee.JndiNameType;
import org.apache.geronimo.xbeans.javaee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.javaee.MessageDestinationType;
import org.apache.geronimo.xbeans.javaee.MessageDestinationTypeType;
import org.apache.geronimo.xbeans.javaee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.javaee.XsdStringType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminObjectRefBuilder
extends AbstractNamingBuilder {
    private static final Log log = LogFactory.getLog(AdminObjectRefBuilder.class);
    private final QNameSet adminOjbectRefQNameSet;
    private final QNameSet messageDestinationQNameSet;
    private final QNameSet messageDestinationRefQNameSet;
    private static final QName GER_ADMIN_OBJECT_REF_QNAME = GerResourceEnvRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_ADMIN_OBJECT_REF_QNAME_SET = QNameSet.singleton((QName)GER_ADMIN_OBJECT_REF_QNAME);
    private static final QName GER_MESSAGE_DESTINATION_QNAME = GerMessageDestinationDocument.type.getDocumentElementName();
    private static final QNameSet GER_MESSAGE_DESTINATION_QNAME_SET = QNameSet.singleton((QName)GER_MESSAGE_DESTINATION_QNAME);
    public static final GBeanInfo GBEAN_INFO;

    public AdminObjectRefBuilder(Environment defaultEnvironment, String[] eeNamespaces) {
        super(defaultEnvironment);
        this.adminOjbectRefQNameSet = AdminObjectRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"resource-env-ref");
        this.messageDestinationQNameSet = AdminObjectRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"message-destination");
        this.messageDestinationRefQNameSet = AdminObjectRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"message-destination-ref");
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.adminOjbectRefQNameSet).length > 0 || specDD.selectChildren(this.messageDestinationRefQNameSet).length > 0;
    }

    public void initContext(XmlObject specDD, XmlObject plan, Module module) throws DeploymentException {
        List specDestinations = AdminObjectRefBuilder.convert((XmlObject[])specDD.selectChildren(this.messageDestinationQNameSet), (NamespaceElementConverter)JEE_CONVERTER, MessageDestinationType.class, (SchemaType)MessageDestinationType.type);
        XmlObject[] gerDestinations = plan.selectChildren(GER_MESSAGE_DESTINATION_QNAME_SET);
        HashMap<String, GerMessageDestinationType> nameMap = new HashMap<String, GerMessageDestinationType>();
        for (XmlObject gerDestination : gerDestinations) {
            GerMessageDestinationType destination = (GerMessageDestinationType)gerDestination.copy().changeType(GerMessageDestinationType.type);
            String name = destination.getMessageDestinationName().trim();
            nameMap.put(name, destination);
            boolean found = false;
            for (MessageDestinationType specDestination : specDestinations) {
                if (!specDestination.getMessageDestinationName().getStringValue().trim().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new DeploymentException("No spec DD message-destination for " + name);
        }
        module.getRootEarContext().registerMessageDestionations(module.getName(), nameMap);
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        XmlObject[] gerResourceEnvRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_ADMIN_OBJECT_REF_QNAME_SET);
        Map<String, GerResourceEnvRefType> refMap = AdminObjectRefBuilder.mapResourceEnvRefs(gerResourceEnvRefsUntyped);
        int initialGerRefSize = refMap.size();
        Map messageDestinations = module.getRootEarContext().getMessageDestinations();
        if (module.getClassFinder() != null) {
            try {
                ResourceAnnotationHelper.processAnnotations((AnnotatedApp)module.getAnnotatedApp(), (ClassFinder)module.getClassFinder(), (ResourceAnnotationHelper.ResourceProcessor)new AdminObjectRefProcessor(refMap, messageDestinations, module.getEarContext()));
            }
            catch (Exception e) {
                log.warn((Object)("Unable to process @Resource annotations for module" + module.getName()), (Throwable)e);
            }
        }
        List resourceEnvRefsUntyped = AdminObjectRefBuilder.convert((XmlObject[])specDD.selectChildren(this.adminOjbectRefQNameSet), (NamespaceElementConverter)JEE_CONVERTER, ResourceEnvRefType.class, (SchemaType)ResourceEnvRefType.type);
        int unresolvedRefSize = resourceEnvRefsUntyped.size();
        ClassLoader cl = module.getEarContext().getClassLoader();
        for (ResourceEnvRefType resourceEnvRef : resourceEnvRefsUntyped) {
            Class<?> iface;
            String name = resourceEnvRef.getResourceEnvRefName().getStringValue().trim();
            this.addInjections(name, resourceEnvRef.getInjectionTargetArray(), componentContext);
            String type = resourceEnvRef.getResourceEnvRefType().getStringValue().trim();
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            GerResourceEnvRefType gerResourceEnvRef = refMap.get(name);
            refMap.remove(name);
            try {
                String refType = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)resourceEnvRef.getResourceEnvRefType());
                if (refType.equals("javax.transaction.UserTransaction")) {
                    UserTransactionReference ref = new UserTransactionReference();
                    this.getJndiContextMap(componentContext).put("env/" + name, ref);
                    continue;
                }
                AbstractNameQuery containerId = AdminObjectRefBuilder.getAdminObjectContainerId(name, gerResourceEnvRef);
                Reference ref = this.buildAdminObjectReference(module, containerId, iface);
                this.getJndiContextMap(componentContext).put("env/" + name, ref);
            }
            catch (UnresolvedReferenceException e) {
                throw new DeploymentException("Unable to resolve resource env reference '" + name + "' (" + (e.isMultiple() ? "found multiple matching resources" : "no matching resources found") + ")", (Throwable)e);
            }
        }
        if (initialGerRefSize - unresolvedRefSize != refMap.size()) {
            log.warn((Object)("Failed to build reference to Admin object reference " + refMap.keySet() + " defined in plan file, reason - corresponding entry in deployment descriptor missing."));
        }
        List messageDestinationRefsUntyped = AdminObjectRefBuilder.convert((XmlObject[])specDD.selectChildren(this.messageDestinationRefQNameSet), (NamespaceElementConverter)JEE_CONVERTER, MessageDestinationRefType.class, (SchemaType)MessageDestinationRefType.type);
        for (MessageDestinationRefType messageDestinationRef : messageDestinationRefsUntyped) {
            Class<?> iface;
            String type;
            String name = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)messageDestinationRef.getMessageDestinationRefName());
            this.addInjections(name, messageDestinationRef.getInjectionTargetArray(), componentContext);
            String linkName = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)messageDestinationRef.getMessageDestinationLink());
            if (linkName == null) {
                linkName = name;
            }
            if ((type = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)messageDestinationRef.getMessageDestinationType())) == null) {
                InjectionTargetType[] targets = messageDestinationRef.getInjectionTargetArray();
                if (targets.length == 0) {
                    throw new DeploymentException("No type for message-destination-ref can be determined from explicit specification or injection target: " + messageDestinationRef);
                }
                type = AdminObjectRefBuilder.getStringValue((org.apache.geronimo.xbeans.javaee.String)targets[0].getInjectionTargetClass());
                if (type == null) {
                    throw new DeploymentException("no type for message destination ref in injection target: " + targets[0]);
                }
            }
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            String moduleURI = null;
            GerMessageDestinationType destination = AdminObjectRefBuilder.getMessageDestination(linkName, messageDestinations);
            if (destination != null) {
                if (destination.isSetAdminObjectLink()) {
                    if (destination.isSetAdminObjectModule()) {
                        moduleURI = destination.getAdminObjectModule().trim();
                    }
                    linkName = destination.getAdminObjectLink().trim();
                }
            } else {
                int pos = linkName.indexOf(35);
                if (pos > -1) {
                    linkName = linkName.substring(pos + 1);
                }
            }
            AbstractNameQuery containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, moduleURI, (String)linkName, (String)"JCAAdminObject", (String)"ResourceAdapterModule");
            Reference ref = this.buildAdminObjectReference(module, containerId, iface);
            this.getJndiContextMap(componentContext).put("env/" + name, ref);
        }
    }

    public static GerMessageDestinationType getMessageDestination(String messageDestinationLink, Map<String, Map<String, GerMessageDestinationType>> messageDestinations) throws DeploymentException {
        GerMessageDestinationType destination = null;
        int pos = messageDestinationLink.indexOf(35);
        if (pos > -1) {
            String targetModule = messageDestinationLink.substring(0, pos);
            Map<String, GerMessageDestinationType> destinations = messageDestinations.get(targetModule);
            if (destinations == null) {
                StringBuffer sb = new StringBuffer();
                for (String o : messageDestinations.keySet()) {
                    sb.append((Object)o).append("\n");
                }
                throw new DeploymentException("Unknown module " + targetModule + " when processing message destination " + messageDestinationLink + "\nKnown modules in deployable unit are:\n" + sb.toString());
            }
            messageDestinationLink = messageDestinationLink.substring(pos + 1);
            destination = destinations.get(messageDestinationLink);
        } else {
            for (Map<String, GerMessageDestinationType> destinations : messageDestinations.values()) {
                GerMessageDestinationType destinationTest = destinations.get(messageDestinationLink);
                if (destinationTest == null) continue;
                if (destination != null) {
                    throw new DeploymentException("Duplicate message destination " + messageDestinationLink + " accessed from a message-destination-link without a module");
                }
                destination = destinationTest;
            }
        }
        return destination;
    }

    private Reference buildAdminObjectReference(Module module, AbstractNameQuery containerId, Class iface) throws DeploymentException {
        Configuration localConfiguration = module.getEarContext().getConfiguration();
        try {
            localConfiguration.findGBean(containerId);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Can not resolve admin object ref " + containerId + " in configuration " + localConfiguration.getId(), (Throwable)e);
        }
        return new ResourceReference(module.getConfigId(), containerId, iface);
    }

    private static AbstractNameQuery getAdminObjectContainerId(String name, GerResourceEnvRefType gerResourceEnvRef) {
        AbstractNameQuery containerId;
        if (gerResourceEnvRef == null) {
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, null, (String)name, (String)"JCAAdminObject", (String)"ResourceAdapterModule");
        } else if (gerResourceEnvRef.isSetMessageDestinationLink()) {
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, null, (String)gerResourceEnvRef.getMessageDestinationLink().trim(), (String)"JCAAdminObject", (String)"ResourceAdapterModule");
        } else if (gerResourceEnvRef.isSetAdminObjectLink()) {
            String moduleURI = null;
            if (gerResourceEnvRef.isSetAdminObjectModule()) {
                moduleURI = gerResourceEnvRef.getAdminObjectModule().trim();
            }
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery(null, (String)moduleURI, (String)gerResourceEnvRef.getAdminObjectLink().trim(), (String)"JCAAdminObject", (String)"ResourceAdapterModule");
        } else {
            GerPatternType patternType = gerResourceEnvRef.getPattern();
            containerId = AdminObjectRefBuilder.buildAbstractNameQuery((GerPatternType)patternType, (String)"JCAAdminObject", (String)"ResourceAdapterModule", null);
        }
        return containerId;
    }

    private static Map<String, GerResourceEnvRefType> mapResourceEnvRefs(XmlObject[] refs) {
        HashMap<String, GerResourceEnvRefType> refMap = new HashMap<String, GerResourceEnvRefType>();
        if (refs != null) {
            for (XmlObject ref1 : refs) {
                GerResourceEnvRefType ref = (GerResourceEnvRefType)ref1.copy().changeType(GerResourceEnvRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    public QNameSet getSpecQNameSet() {
        return this.adminOjbectRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_ADMIN_OBJECT_REF_QNAME_SET;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(AdminObjectRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdminObjectRefProcessor
    extends ResourceAnnotationHelper.ResourceProcessor {
        private final EARContext earContext;
        private final Map<String, GerResourceEnvRefType> refMap;
        private final Map<String, Map<String, GerMessageDestinationType>> messageDestinations;

        public AdminObjectRefProcessor(Map<String, GerResourceEnvRefType> refMap, Map<String, Map<String, GerMessageDestinationType>> messageDestinations, EARContext earContext) {
            this.refMap = refMap;
            this.messageDestinations = messageDestinations;
            this.earContext = earContext;
        }

        public boolean processResource(AnnotatedApp annotatedApp, Resource annotation, Class cls, Method method, Field field) throws DeploymentException {
            ResourceEnvRefType[] ResourceEnvRefs;
            MessageDestinationRefType[] messageDestinationRefs;
            String resourceName = AdminObjectRefProcessor.getResourceName((Resource)annotation, (Method)method, (Field)field);
            String resourceType = AdminObjectRefProcessor.getResourceType((Resource)annotation, (Method)method, (Field)field);
            if (resourceType.equals("javax.ejb.SessionContext")) {
                return true;
            }
            if (resourceType.equals("javax.ejb.MessageDrivenContext")) {
                return true;
            }
            if (resourceType.equals("javax.ejb.EntityContext")) {
                return true;
            }
            for (MessageDestinationRefType messageDestinationRef : messageDestinationRefs = annotatedApp.getMessageDestinationRefArray()) {
                InjectionTargetType[] targets;
                if (!messageDestinationRef.getMessageDestinationRefName().getStringValue().trim().equals(resourceName)) continue;
                if (!(method == null && field == null || AdminObjectRefProcessor.hasTarget((Method)method, (Field)field, (InjectionTargetType[])(targets = messageDestinationRef.getInjectionTargetArray())))) {
                    AdminObjectRefProcessor.configureInjectionTarget((InjectionTargetType)messageDestinationRef.addNewInjectionTarget(), (Method)method, (Field)field);
                }
                return true;
            }
            for (ResourceEnvRefType resourceEnvRefType : ResourceEnvRefs = annotatedApp.getResourceEnvRefArray()) {
                InjectionTargetType[] targets;
                if (!resourceEnvRefType.getResourceEnvRefName().getStringValue().trim().equals(resourceName)) continue;
                if (!(method == null && field == null || AdminObjectRefProcessor.hasTarget((Method)method, (Field)field, (InjectionTargetType[])(targets = resourceEnvRefType.getInjectionTargetArray())))) {
                    AdminObjectRefProcessor.configureInjectionTarget((InjectionTargetType)resourceEnvRefType.addNewInjectionTarget(), (Method)method, (Field)field);
                }
                return true;
            }
            GerMessageDestinationType gerMessageDestinationType = AdminObjectRefBuilder.getMessageDestination(resourceName, this.messageDestinations);
            if (gerMessageDestinationType != null) {
                this.addMethodDestinationRef(annotatedApp, resourceName, resourceType, method, field, annotation);
                return true;
            }
            GerResourceEnvRefType resourceEnvRefType = this.refMap.get(resourceName);
            if (resourceEnvRefType != null || resourceType.equals("javax.transaction.UserTransaction")) {
                this.addResourceEnvRef(annotatedApp, resourceName, resourceType, method, field, annotation);
                return true;
            }
            AbstractNameQuery containerId = AbstractNamingBuilder.buildAbstractNameQuery(null, null, (String)resourceName, (String)"JCAAdminObject", (String)"ResourceAdapterModule");
            try {
                this.earContext.findGBean(containerId);
            }
            catch (GBeanNotFoundException e) {
                return false;
            }
            this.addResourceEnvRef(annotatedApp, resourceName, resourceType, method, field, annotation);
            return true;
        }

        private void addResourceEnvRef(AnnotatedApp annotatedApp, String resourceName, String resourceType, Method method, Field field, Resource annotation) {
            String mappdedNameAnnotation;
            String descriptionAnnotation;
            ResourceEnvRefType resourceEnvRef = annotatedApp.addNewResourceEnvRef();
            JndiNameType resourceEnvRefName = resourceEnvRef.addNewResourceEnvRefName();
            resourceEnvRefName.setStringValue(resourceName);
            resourceEnvRef.setResourceEnvRefName(resourceEnvRefName);
            if (!resourceType.equals("")) {
                FullyQualifiedClassType qualifiedClass = resourceEnvRef.addNewResourceEnvRefType();
                qualifiedClass.setStringValue(resourceType);
                resourceEnvRef.setResourceEnvRefType(qualifiedClass);
            }
            if (method != null || field != null) {
                InjectionTargetType injectionTarget = resourceEnvRef.addNewInjectionTarget();
                AdminObjectRefProcessor.configureInjectionTarget((InjectionTargetType)injectionTarget, (Method)method, (Field)field);
            }
            if (!(descriptionAnnotation = annotation.description()).equals("")) {
                DescriptionType description = resourceEnvRef.addNewDescription();
                description.setStringValue(descriptionAnnotation);
            }
            if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                XsdStringType mappedName = resourceEnvRef.addNewMappedName();
                mappedName.setStringValue(mappdedNameAnnotation);
                resourceEnvRef.setMappedName(mappedName);
            }
        }

        private void addMethodDestinationRef(AnnotatedApp annotatedApp, String resourceName, String resourceType, Method method, Field field, Resource annotation) {
            String mappdedNameAnnotation;
            String descriptionAnnotation;
            MessageDestinationRefType messageDestinationRef = annotatedApp.addNewMessageDestinationRef();
            JndiNameType messageDestinationRefName = messageDestinationRef.addNewMessageDestinationRefName();
            messageDestinationRefName.setStringValue(resourceName);
            messageDestinationRef.setMessageDestinationRefName(messageDestinationRefName);
            if (!resourceType.equals("")) {
                MessageDestinationTypeType msgDestType = messageDestinationRef.addNewMessageDestinationType();
                msgDestType.setStringValue(resourceType);
                messageDestinationRef.setMessageDestinationType(msgDestType);
            }
            if (method != null || field != null) {
                InjectionTargetType injectionTarget = messageDestinationRef.addNewInjectionTarget();
                AdminObjectRefProcessor.configureInjectionTarget((InjectionTargetType)injectionTarget, (Method)method, (Field)field);
            }
            if (!(descriptionAnnotation = annotation.description()).equals("")) {
                DescriptionType description = messageDestinationRef.addNewDescription();
                description.setStringValue(descriptionAnnotation);
            }
            if (!(mappdedNameAnnotation = annotation.mappedName()).equals("")) {
                XsdStringType mappedName = messageDestinationRef.addNewMappedName();
                mappedName.setStringValue(mappdedNameAnnotation);
                messageDestinationRef.setMappedName(mappedName);
            }
        }
    }
}

