/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.deployment.ConnectorModuleBuilder;
import org.apache.geronimo.xbeans.geronimo.GerConnectionDefinitionType;
import org.apache.geronimo.xbeans.geronimo.GerConnectiondefinitionInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.GerResourceadapterType;
import org.apache.xmlbeans.XmlCursor;

public class ConnectorPlanRectifier {
    private static final Log log = LogFactory.getLog((Class)ConnectorPlanRectifier.class);
    private static final QName VERSION_QNAME = new QName("", "version");
    private static final QName GLOBAL_JNDI_NAME_QNAME = new QName(ConnectorModuleBuilder.GERCONNECTOR_NAMESPACE, "global-jndi-name");
    private static final QName CREDENTIAL_INTERFACE_QNAME = new QName(ConnectorModuleBuilder.GERCONNECTOR_NAMESPACE, "credential-interface");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rectifyPlan(GerConnectorType gerConnector) {
        boolean updated = false;
        XmlCursor cursor = gerConnector.newCursor();
        try {
            updated = cursor.removeAttribute(VERSION_QNAME);
        }
        finally {
            cursor.dispose();
        }
        GerResourceadapterType[] resourceAdapters = gerConnector.getResourceadapterArray();
        for (int i = 0; i < resourceAdapters.length; ++i) {
            GerResourceadapterType resourceAdapter = resourceAdapters[i];
            if (!resourceAdapter.isSetOutboundResourceadapter()) continue;
            GerConnectionDefinitionType[] connectionDefinitions = resourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray();
            for (int j = 0; j < connectionDefinitions.length; ++j) {
                GerConnectionDefinitionType connectionDefinition = connectionDefinitions[j];
                GerConnectiondefinitionInstanceType[] connectiondefinitionInstances = connectionDefinition.getConnectiondefinitionInstanceArray();
                for (int k = 0; k < connectiondefinitionInstances.length; ++k) {
                    GerConnectiondefinitionInstanceType connectiondefinitionInstance = connectiondefinitionInstances[k];
                    cursor = connectiondefinitionInstance.newCursor();
                    try {
                        if (!cursor.toFirstChild()) continue;
                        if (cursor.toNextSibling(GLOBAL_JNDI_NAME_QNAME)) {
                            cursor.removeXml();
                            updated = true;
                        }
                        if (!cursor.toNextSibling(CREDENTIAL_INTERFACE_QNAME)) continue;
                        cursor.removeXml();
                        updated = true;
                        continue;
                    }
                    finally {
                        cursor.dispose();
                    }
                }
            }
        }
        if (updated) {
            log.warn((Object)"Your connector plan has obsolete elements or attributes in it.  Please remove version attributes, global-jndi-name elements, and credential-interface elements");
        }
    }
}

