/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.executor;

import java.util.Properties;
import org.apache.geronimo.concurrent.impl.NotificationHelper;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThread;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactory;
import org.apache.geronimo.concurrent.impl.thread.ManagedThreadGBean;
import org.apache.geronimo.concurrent.impl.thread.TrackingManagedThreadFactory;

public class ServerManagedThreadFactory
extends TrackingManagedThreadFactory {
    private NotificationHelper notificationHelper;

    public ServerManagedThreadFactory(GeronimoManagedThreadFactory factory, NotificationHelper notificationHelper) {
        super(factory);
        this.notificationHelper = notificationHelper;
    }

    private void sendNotification(ManagedThreadGBean threadGBean) {
        if (this.notificationHelper.isNotificationSupported()) {
            Properties userData = new Properties();
            userData.setProperty("managedthread", threadGBean.getObjectName());
            this.notificationHelper.sendNotification("threadfactory.newthread", userData);
        }
    }

    public Thread newThread(Runnable runnable) {
        GeronimoManagedThread thread = (GeronimoManagedThread)((Object)super.newThread(runnable));
        this.sendNotification(thread.getGbean());
        return thread;
    }

    public String[] getEventTypes() {
        return new String[]{"threadfactory.newthread"};
    }

    public String[] getThreads() {
        return GeronimoManagedThreadFactory.getThreads(this.getThreadList());
    }

    public String[] getHungTaskThreads() {
        return GeronimoManagedThreadFactory.getHungTaskThreads(this.getThreadList());
    }
}

