/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.ManagedContextHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextHandlerUtils {
    private static final Log LOG = LogFactory.getLog(ContextHandlerUtils.class);

    public static List<ManagedContextHandler> loadHandlers(ClassLoader classLoader, String[] handlerClasses) {
        ArrayList<ManagedContextHandler> handlers = new ArrayList<ManagedContextHandler>();
        if (handlerClasses != null) {
            for (String handlerClass : handlerClasses) {
                try {
                    handlers.add(ContextHandlerUtils.loadHandler(classLoader, handlerClass.trim()));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to load context handler class " + handlerClass), (Throwable)e);
                }
            }
        }
        return handlers;
    }

    public static ManagedContextHandler loadHandler(ClassLoader classLoader, String className) throws Exception {
        Class<?> clazz = classLoader.loadClass(className);
        if (!ManagedContextHandler.class.isAssignableFrom(clazz)) {
            throw new Exception("Class " + className + " is not a ManagedContextHandler class");
        }
        return (ManagedContextHandler)clazz.newInstance();
    }
}

