/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.apache.geronimo.client.AppClientInitializationException;
import org.apache.geronimo.client.AppClientPlugin;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.Injection;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.credentialstore.CredentialStore;
import org.apache.geronimo.security.deploy.SubjectInfo;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.StaticRecipe;

public final class AppClientContainer
implements GBeanLifecycle {
    private static final Class[] MAIN_ARGS = new Class[]{String[].class};
    private LoginContext loginContext;
    private final String mainClassName;
    private final AppClientPlugin jndiContext;
    private final AbstractName appClientModuleName;
    private final String realmName;
    private final String callbackHandlerClass;
    private final Subject defaultSubject;
    private final Method mainMethod;
    private final ClassLoader classLoader;
    private final Kernel kernel;
    private final Holder holder;
    private CallbackHandler callbackHandler;
    public static final GBeanInfo GBEAN_INFO;

    public AppClientContainer(String mainClassName, AbstractName appClientModuleName, String realmName, String callbackHandlerClassName, SubjectInfo defaultSubject, Holder holder, AppClientPlugin jndiContext, CredentialStore credentialStore, ClassLoader classLoader, Kernel kernel) throws Exception {
        System.setProperty("openejb.client.identityResolver", "geronimo");
        this.mainClassName = mainClassName;
        this.appClientModuleName = appClientModuleName;
        if (realmName == null != (callbackHandlerClassName == null)) {
            throw new IllegalArgumentException("You must supply both realmName and callbackHandlerClass or neither");
        }
        this.realmName = realmName;
        this.callbackHandlerClass = callbackHandlerClassName;
        this.defaultSubject = defaultSubject != null ? credentialStore.getSubject(defaultSubject.getRealm(), defaultSubject.getId()) : null;
        this.holder = holder == null ? Holder.EMPTY : holder;
        this.classLoader = classLoader;
        this.kernel = kernel;
        this.jndiContext = jndiContext;
        try {
            Class<?> mainClass = classLoader.loadClass(mainClassName);
            this.mainMethod = mainClass.getMethod("main", MAIN_ARGS);
        }
        catch (ClassNotFoundException e) {
            throw new AppClientInitializationException("Unable to load Main-Class " + mainClassName, e);
        }
        catch (NoSuchMethodException e) {
            throw new AppClientInitializationException("Main-Class " + mainClassName + " does not have a main method", e);
        }
    }

    public AbstractName getAppClientModuleName() {
        return this.appClientModuleName;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void main(final String[] args) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        Callers oldCallers = ContextManager.getCallers();
        Subject clientSubject = this.defaultSubject;
        try {
            Class<?> mainClass;
            thread.setContextClassLoader(this.classLoader);
            this.jndiContext.startClient(this.appClientModuleName, this.kernel, this.classLoader);
            Context componentContext = this.jndiContext.getJndiContext();
            if (this.callbackHandlerClass != null) {
                this.callbackHandler = (CallbackHandler)this.holder.newInstance(this.callbackHandlerClass, this.classLoader, componentContext);
                this.loginContext = ContextManager.login((String)this.realmName, (CallbackHandler)this.callbackHandler);
                clientSubject = this.loginContext.getSubject();
            }
            ContextManager.setCallers((Subject)clientSubject, (Subject)clientSubject);
            ObjectRecipe objectRecipe = new ObjectRecipe(mainClass);
            objectRecipe.allow(Option.FIELD_INJECTION);
            objectRecipe.allow(Option.PRIVATE_PROPERTIES);
            objectRecipe.allow(Option.STATIC_PROPERTIES);
            ArrayList injections = new ArrayList();
            for (mainClass = this.classLoader.loadClass(this.mainClassName); mainClass != null && mainClass != Object.class; mainClass = mainClass.getSuperclass()) {
                List perClass = this.holder.getInjections(mainClass.getName());
                if (perClass == null) continue;
                injections.addAll(perClass);
            }
            if (injections != null) {
                ArrayList<NamingException> problems = new ArrayList<NamingException>();
                for (Injection injection : injections) {
                    try {
                        String jndiName = injection.getJndiName();
                        Object object = componentContext.lookup("env/" + jndiName);
                        if (object instanceof String) {
                            String string = (String)object;
                            objectRecipe.setProperty(injection.getTargetName(), (Object)string);
                            continue;
                        }
                        objectRecipe.setProperty(injection.getTargetName(), (Object)new StaticRecipe(object));
                    }
                    catch (NamingException e) {
                        problems.add(e);
                    }
                }
                if (!problems.isEmpty()) {
                    throw new Exception("Some objects to be injected were not found in jndi: " + problems);
                }
            }
            Class clazz = objectRecipe.setStaticProperties();
            if (this.holder.getPostConstruct() != null) {
                Holder.apply(null, (Class)clazz, (Map)this.holder.getPostConstruct());
            }
            if (clientSubject == null) {
                this.mainMethod.invoke(null, new Object[]{args});
            } else {
                Subject.doAs(clientSubject, new PrivilegedAction(){

                    public Object run() {
                        try {
                            AppClientContainer.this.mainMethod.invoke(null, new Object[]{args});
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new Error(e);
        }
        finally {
            thread.setContextClassLoader(oldClassLoader);
            ContextManager.popCallers((Callers)oldCallers);
        }
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        if (this.callbackHandler != null) {
            this.holder.destroyInstance((Object)this.callbackHandler);
        }
        if (this.loginContext != null) {
            ContextManager.logout((LoginContext)this.loginContext);
        }
        this.jndiContext.stopClient(this.appClientModuleName);
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(AppClientContainer.class, (String)"AppClient");
        infoFactory.addAttribute("mainClassName", String.class, true);
        infoFactory.addAttribute("appClientModuleName", AbstractName.class, true);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("callbackHandlerClassName", String.class, true);
        infoFactory.addAttribute("defaultSubject", SubjectInfo.class, true);
        infoFactory.addAttribute("holder", Holder.class, true);
        infoFactory.addReference("JNDIContext", AppClientPlugin.class, "GBean");
        infoFactory.addReference("CredentialStore", CredentialStore.class, "GBean");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"mainClassName", "appClientModuleName", "realmName", "callbackHandlerClassName", "defaultSubject", "holder", "JNDIContext", "CredentialStore", "classLoader", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

