/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client;

import [Ljava.lang.String;;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.client.AppClientInitializationException;
import org.apache.geronimo.client.AppClientPlugin;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.util.ConfigurationUtil;

public final class AppClientContainer {
    private static final Class[] MAIN_ARGS = new Class[]{String;.class};
    private final String mainClassName;
    private final AppClientPlugin jndiContext;
    private final AbstractName appClientModuleName;
    private final String realmName;
    private final Class callbackHandlerClass;
    private final Subject defaultSubject;
    private final Method mainMethod;
    private final ClassLoader classLoader;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public AppClientContainer(String mainClassName, AbstractName appClientModuleName, String realmName, String callbackHandlerClassName, DefaultPrincipal defaultPrincipal, AppClientPlugin jndiContext, ClassLoader classLoader, Kernel kernel) throws Exception {
        this.mainClassName = mainClassName;
        this.appClientModuleName = appClientModuleName;
        if (realmName == null != (callbackHandlerClassName == null)) {
            throw new IllegalArgumentException("You must supply both realmName and callbackHandlerClass or neither");
        }
        this.realmName = realmName;
        if (callbackHandlerClassName != null) {
            try {
                this.callbackHandlerClass = classLoader.loadClass(callbackHandlerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new AppClientInitializationException("Could not load callbackHandlerClass", e);
            }
        } else {
            this.callbackHandlerClass = null;
        }
        this.defaultSubject = defaultPrincipal != null ? ConfigurationUtil.generateDefaultSubject((DefaultPrincipal)defaultPrincipal, (ClassLoader)classLoader) : null;
        this.classLoader = classLoader;
        this.kernel = kernel;
        this.jndiContext = jndiContext;
        try {
            Class<?> mainClass = classLoader.loadClass(mainClassName);
            this.mainMethod = mainClass.getMethod("main", MAIN_ARGS);
        }
        catch (ClassNotFoundException e) {
            throw new AppClientInitializationException("Unable to load Main-Class " + mainClassName, e);
        }
        catch (NoSuchMethodException e) {
            throw new AppClientInitializationException("Main-Class " + mainClassName + " does not have a main method", e);
        }
    }

    public AbstractName getAppClientModuleName() {
        return this.appClientModuleName;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void main(final String[] args) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        Callers oldCallers = ContextManager.getCallers();
        Subject clientSubject = this.defaultSubject;
        LoginContext loginContext = null;
        try {
            thread.setContextClassLoader(this.classLoader);
            if (this.callbackHandlerClass != null) {
                CallbackHandler callbackHandler;
                try {
                    Constructor cArgs = this.callbackHandlerClass.getConstructor(String;.class);
                    callbackHandler = (CallbackHandler)cArgs.newInstance(new Object[]{args});
                }
                catch (NoSuchMethodException e) {
                    callbackHandler = (CallbackHandler)this.callbackHandlerClass.newInstance();
                }
                loginContext = new LoginContext(this.realmName, callbackHandler);
                try {
                    loginContext.login();
                }
                catch (LoginException e) {
                    loginContext = null;
                    throw e;
                }
                clientSubject = loginContext.getSubject();
            }
            ContextManager.setCallers((Subject)clientSubject, (Subject)clientSubject);
            this.jndiContext.startClient(this.appClientModuleName, this.kernel, this.classLoader);
            if (clientSubject == null) {
                this.mainMethod.invoke(null, new Object[]{args});
            } else {
                Subject.doAs(clientSubject, new PrivilegedAction(){

                    public Object run() {
                        try {
                            AppClientContainer.this.mainMethod.invoke(null, new Object[]{args});
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new Error(e);
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
            this.jndiContext.stopClient(this.appClientModuleName);
            thread.setContextClassLoader(oldClassLoader);
            ContextManager.popCallers((Callers)oldCallers);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)AppClientContainer.class, (String)"AppClient");
        infoFactory.addOperation("main", new Class[]{String;.class});
        infoFactory.addAttribute("mainClassName", String.class, true);
        infoFactory.addAttribute("appClientModuleName", AbstractName.class, true);
        infoFactory.addAttribute("realmName", String.class, true);
        infoFactory.addAttribute("callbackHandlerClassName", String.class, true);
        infoFactory.addAttribute("defaultPrincipal", DefaultPrincipal.class, true);
        infoFactory.addReference("JNDIContext", AppClientPlugin.class, "GBean");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"mainClassName", "appClientModuleName", "realmName", "callbackHandlerClassName", "defaultPrincipal", "JNDIContext", "classLoader", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

