/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client.builder;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.MultipleMatchesException;
import org.apache.geronimo.system.resolver.ExplicitDefaultArtifactResolver;
import org.apache.geronimo.system.serverinfo.ServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalExplicitDefaultArtifactResolver
implements ArtifactResolver {
    private final ArtifactResolver delegate;
    public static final GBeanInfo GBEAN_INFO;

    public OptionalExplicitDefaultArtifactResolver(String versionMapLocation, Collection<ArtifactManager> artifactManagers, Collection<ListableRepository> repositories, Collection<ServerInfo> serverInfos, Collection<ArtifactResolver> fallbackResolver) throws IOException {
        ServerInfo serverInfo = OptionalExplicitDefaultArtifactResolver.getServerInfo(serverInfos);
        if (serverInfo != null) {
            this.delegate = new ExplicitDefaultArtifactResolver(versionMapLocation, OptionalExplicitDefaultArtifactResolver.getArtifactManager(artifactManagers), repositories, serverInfo);
        } else {
            if (fallbackResolver == null || fallbackResolver.isEmpty()) {
                throw new IllegalStateException("No ServerInfo and no delegate ArtifactResolver supplied");
            }
            this.delegate = fallbackResolver.iterator().next();
        }
    }

    private static ServerInfo getServerInfo(Collection<ServerInfo> serverInfo) {
        if (serverInfo == null || serverInfo.isEmpty()) {
            return null;
        }
        return serverInfo.iterator().next();
    }

    private static ArtifactManager getArtifactManager(Collection<ArtifactManager> artifactManagers) {
        if (artifactManagers == null || artifactManagers.isEmpty()) {
            throw new IllegalStateException("No ArtifactManager found");
        }
        return artifactManagers.iterator().next();
    }

    public Artifact generateArtifact(Artifact source, String defaultType) {
        return this.delegate.generateArtifact(source, defaultType);
    }

    public Artifact resolveInClassLoader(Artifact source) throws MissingDependencyException {
        return this.delegate.resolveInClassLoader(source);
    }

    public Artifact resolveInClassLoader(Artifact source, Collection parentConfigurations) throws MissingDependencyException {
        return this.delegate.resolveInClassLoader(source, parentConfigurations);
    }

    public LinkedHashSet resolveInClassLoader(Collection artifacts) throws MissingDependencyException {
        return this.delegate.resolveInClassLoader(artifacts);
    }

    public LinkedHashSet resolveInClassLoader(Collection artifacts, Collection parentConfigurations) throws MissingDependencyException {
        return this.delegate.resolveInClassLoader(artifacts, parentConfigurations);
    }

    public Artifact queryArtifact(Artifact artifact) throws MultipleMatchesException {
        return this.delegate.queryArtifact(artifact);
    }

    public Artifact[] queryArtifacts(Artifact artifact) {
        return this.delegate.queryArtifacts(artifact);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(OptionalExplicitDefaultArtifactResolver.class, (String)"ArtifactResolver");
        infoFactory.addAttribute("versionMapLocation", String.class, true, true);
        infoFactory.addReference("ArtifactManager", ArtifactManager.class, "ArtifactManager");
        infoFactory.addReference("Repositories", ListableRepository.class, "Repository");
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addReference("FallbackArtifactResolver", ArtifactResolver.class, "ArtifactResolver");
        infoFactory.addInterface(ArtifactResolver.class);
        infoFactory.setConstructor(new String[]{"versionMapLocation", "ArtifactManager", "Repositories", "ServerInfo", "FallbackArtifactResolver"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

