/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.feature;

import javax.xml.ws.soap.AddressingFeature;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.server.config.AddressingConfigurator;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.geronimo.axis2.feature.WebServiceFeatureConfigurator;
import org.apache.geronimo.jaxws.feature.AddressingFeatureInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressingFeatureConfigurator
implements WebServiceFeatureConfigurator<AddressingFeatureInfo> {
    private static Logger logger = LoggerFactory.getLogger(AddressingConfigurator.class);

    @Override
    public void configure(EndpointDescription endpointDescription, AddressingFeatureInfo webServiceFeatureInfo) {
        if (webServiceFeatureInfo == null) {
            return;
        }
        Parameter disabled = new Parameter("disableAddressingForInMessages", (Object)String.valueOf(!webServiceFeatureInfo.isEnabled()));
        Parameter required = new Parameter("addressingRequirementParameter", (Object)(webServiceFeatureInfo.isRequired() ? "required" : "unspecified"));
        Parameter responses = new Parameter("wsamInvocationPattern", (Object)this.mapResponseAttributeToAddressing(webServiceFeatureInfo.getResponses()));
        try {
            ServiceDescription sd;
            AxisConfiguration axisConfig;
            AxisService service = endpointDescription.getAxisService();
            service.addParameter(disabled);
            service.addParameter(required);
            service.addParameter(responses);
            String value = Utils.getParameterValue((Parameter)disabled);
            if (JavaUtils.isFalseExplicitly((String)value) && !(axisConfig = (sd = endpointDescription.getServiceDescription()).getAxisConfigContext().getAxisConfiguration()).isEngaged("addressing")) {
                axisConfig.engageModule("addressing");
            }
        }
        catch (Exception e) {
            logger.error("Fail to configure addressing info ", (Throwable)e);
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"AddressingEngagementError", (String)e.toString()));
        }
    }

    private String mapResponseAttributeToAddressing(AddressingFeature.Responses responses) {
        String addressingType = null;
        switch (responses) {
            case ALL: {
                addressingType = "both";
                break;
            }
            case ANONYMOUS: {
                addressingType = "synchronous";
                break;
            }
            case NON_ANONYMOUS: {
                addressingType = "asynchronous";
            }
        }
        return addressingType;
    }
}

