/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.geronimo.axis2.AxisServiceGenerator;
import org.apache.geronimo.jaxws.WSDLUtils;
import org.apache.geronimo.jaxws.wsdl.CatalogWSDLLocator;
import org.apache.xml.resolver.Catalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLQueryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WSDLQueryHandler.class);
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Map<String, Definition> wsdlMap;
    private Map<String, SchemaReference> schemaMap;
    private Map<String, String> importMap;
    private int wsdlCounter;
    private int schemaCounter;
    private AxisService service;
    private Catalog catalog;

    public WSDLQueryHandler(AxisService service) {
        this.service = service;
        EndpointDescription ed = AxisServiceGenerator.getEndpointDescription(this.service);
        JAXWSCatalogManager catalogManager = ed.getServiceDescription().getCatalogManager();
        if (catalogManager != null) {
            this.catalog = catalogManager.getCatalog();
        }
    }

    public void writeResponse(String baseUri, String wsdlUri, OutputStream os) throws Exception {
        Element rootElement;
        String base = null;
        String wsdlKey = "";
        String xsdKey = null;
        int idx = baseUri.toLowerCase().indexOf("?wsdl");
        if (idx != -1) {
            base = baseUri.substring(0, idx);
            wsdlKey = baseUri.substring(idx + 5);
            if (wsdlKey.length() > 0) {
                wsdlKey = wsdlKey.substring(1);
            }
        } else {
            idx = baseUri.toLowerCase().indexOf("?xsd");
            if (idx != -1) {
                base = baseUri.substring(0, idx);
                xsdKey = baseUri.substring(idx + 4);
                if (xsdKey.length() > 0) {
                    xsdKey = xsdKey.substring(1);
                }
            } else {
                throw new Exception("Invalid request: " + baseUri);
            }
        }
        this.init(wsdlUri, base);
        if (xsdKey == null) {
            Definition def = this.wsdlMap.get(wsdlKey);
            if (def == null) {
                throw new FileNotFoundException("WSDL not found: " + wsdlKey);
            }
            if (wsdlKey.equals("")) {
                WSDLUtils.updateLocations((Definition)def, (String)base);
            }
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLWriter writer = factory.newWSDLWriter();
            rootElement = writer.getDocument(def).getDocumentElement();
            this.updateWSDLImports(rootElement, base, wsdlKey);
            this.updateSchemaImports(rootElement, base, wsdlKey);
        } else {
            SchemaReference si = this.schemaMap.get(xsdKey);
            if (si == null) {
                throw new FileNotFoundException("Schema not found: " + xsdKey);
            }
            rootElement = si.getReferencedSchema().getElement();
            this.updateSchemaImports(rootElement, base, xsdKey);
        }
        WSDLQueryHandler.writeTo(rootElement, os);
    }

    private synchronized void init(String wsdlUri, String base) throws WSDLException {
        if (this.importMap == null) {
            this.wsdlMap = new HashMap<String, Definition>();
            this.schemaMap = new HashMap<String, SchemaReference>();
            this.importMap = new HashMap<String, String>();
            HashMap<String, String> docMap = new HashMap<String, String>();
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL((WSDLLocator)new CatalogWSDLLocator(wsdlUri, this.catalog));
            this.updateDefinition("", def, docMap, base);
            WSDLUtils.trimDefinition((Definition)def, (String)this.service.getName(), (String)this.service.getEndpointName());
            this.wsdlMap.put("", def);
        }
    }

    private void updateWSDLImports(Element rootElement, String base, String parentDocKey) {
        NodeList nl = rootElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        for (int x = 0; x < nl.getLength(); ++x) {
            Element el = (Element)nl.item(x);
            String location = el.getAttribute("location");
            String importId = parentDocKey + "/" + location;
            String docKey = this.importMap.get(importId);
            if (docKey == null) continue;
            el.setAttribute("location", base + "?wsdl=" + docKey);
        }
    }

    private void updateSchemaImports(Element rootElement, String base, String parentDocKey) {
        String docKey;
        String importId;
        String location;
        Element el;
        int x;
        NodeList nl = rootElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            location = el.getAttribute("schemaLocation");
            importId = parentDocKey + "/" + location;
            docKey = this.importMap.get(importId);
            if (docKey == null) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + docKey);
        }
        nl = rootElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            location = el.getAttribute("schemaLocation");
            importId = parentDocKey + "/" + location;
            docKey = this.importMap.get(importId);
            if (docKey == null) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + docKey);
        }
    }

    protected void updateDefinition(String parentDocKey, Definition def, Map<String, String> docMap, String base) {
        Collection imports = def.getImports().values();
        Iterator i$ = imports.iterator();
        while (i$.hasNext()) {
            List lst;
            List impLst = lst = (List)i$.next();
            for (Import imp : impLst) {
                String docURI = imp.getDefinition().getDocumentBaseURI();
                String location = imp.getLocationURI();
                String importId = parentDocKey + "/" + location;
                String docKey = docMap.get(docURI);
                if (docKey == null) {
                    docKey = this.getUniqueWSDLId();
                    docMap.put(docURI, docKey);
                    this.wsdlMap.put(docKey, imp.getDefinition());
                    this.updateDefinition(docKey, imp.getDefinition(), docMap, base);
                }
                this.importMap.put(importId, docKey);
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : types.getExtensibilityElements()) {
                if (!(el instanceof Schema)) continue;
                Schema schema = (Schema)el;
                this.updateSchemaImports(parentDocKey, schema, docMap, base);
            }
        }
    }

    protected void updateSchemaImports(String parentDocKey, Schema schema, Map<String, String> docMap, String base) {
        Collection imports = schema.getImports().values();
        Iterator i$ = imports.iterator();
        while (i$.hasNext()) {
            List list;
            List impList = list = (List)i$.next();
            for (SchemaImport s : impList) {
                Schema importedSchema = s.getReferencedSchema();
                if (importedSchema == null) continue;
                String docURI = importedSchema.getDocumentBaseURI();
                String location = s.getSchemaLocationURI();
                String importId = parentDocKey + "/" + location;
                String docKey = docMap.get(docURI);
                if (docKey == null) {
                    docKey = this.getUniqueSchemaId();
                    docMap.put(docURI, docKey);
                    this.schemaMap.put(docKey, (SchemaReference)s);
                    this.updateSchemaImports(docKey, importedSchema, docMap, base);
                }
                this.importMap.put(importId, docKey);
            }
        }
        List includes = schema.getIncludes();
        for (SchemaReference s : includes) {
            Schema includedSchema = s.getReferencedSchema();
            if (includedSchema == null) continue;
            String docURI = includedSchema.getDocumentBaseURI();
            String location = s.getSchemaLocationURI();
            String importId = parentDocKey + "/" + location;
            String docKey = docMap.get(docURI);
            if (docKey == null) {
                docKey = this.getUniqueSchemaId();
                docMap.put(docURI, docKey);
                this.schemaMap.put(docKey, s);
                this.updateSchemaImports(docKey, includedSchema, docMap, base);
            }
            this.importMap.put(importId, docKey);
        }
    }

    private String getUniqueSchemaId() {
        return "xsd" + ++this.schemaCounter;
    }

    private String getUniqueWSDLId() {
        return "wsdl" + ++this.wsdlCounter;
    }

    public static void writeTo(Node node, OutputStream os) {
        WSDLQueryHandler.writeTo(new DOMSource(node), os);
    }

    public static void writeTo(Source src, OutputStream os) {
        try {
            Transformer it = transformerFactory.newTransformer();
            it.setOutputProperty("method", "xml");
            it.setOutputProperty("indent", "yes");
            it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            it.setOutputProperty("omit-xml-declaration", "no");
            it.setOutputProperty("encoding", "utf-8");
            it.transform(src, new StreamResult(os));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

