/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.ejb;

import java.net.URL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.geronimo.axis2.Axis2WebServiceContainer;
import org.apache.geronimo.axis2.AxisServiceGenerator;
import org.apache.geronimo.axis2.GeronimoFactoryRegistry;
import org.apache.geronimo.axis2.ejb.EJBEndpointLifecycleManager;
import org.apache.geronimo.axis2.ejb.EJBMessageReceiver;
import org.apache.geronimo.jaxws.JAXWSAnnotationProcessor;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.openejb.DeploymentInfo;

public class EJBWebServiceContainer
extends Axis2WebServiceContainer {
    private DeploymentInfo deploymnetInfo;

    public EJBWebServiceContainer(PortInfo portInfo, String endpointClassName, ClassLoader classLoader, Context context, URL configurationBaseUrl, DeploymentInfo deploymnetInfo) {
        super(portInfo, endpointClassName, classLoader, context, configurationBaseUrl);
        this.deploymnetInfo = deploymnetInfo;
    }

    public void init() throws Exception {
        super.init();
        String rootContext = null;
        String servicePath = null;
        String location = EJBWebServiceContainer.trimContext((String)this.portInfo.getLocation());
        int pos = location.indexOf(47);
        if (pos > 0) {
            rootContext = location.substring(0, pos);
            servicePath = location.substring(pos + 1);
        } else {
            rootContext = "/";
            servicePath = location;
        }
        this.configurationContext.setServicePath(servicePath);
        this.configurationContext.setContextRoot(rootContext);
        try {
            this.configureHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
        this.factoryRegistry = new GeronimoFactoryRegistry();
        this.factoryRegistry.put(EndpointLifecycleManager.class, (Object)new EJBEndpointLifecycleManager());
    }

    protected AxisServiceGenerator createServiceGenerator() {
        AxisServiceGenerator serviceGenerator = super.createServiceGenerator();
        serviceGenerator.setCatalogName("META-INF/jax-ws-catalog.xml");
        EJBMessageReceiver messageReceiver = new EJBMessageReceiver(this, this.endpointClass, this.deploymnetInfo);
        serviceGenerator.setMessageReceiver((MessageReceiver)messageReceiver);
        return serviceGenerator;
    }

    public synchronized void injectHandlers() {
        if (this.annotationProcessor != null) {
            return;
        }
        WebServiceContext wsContext = null;
        try {
            InitialContext ctx = new InitialContext();
            wsContext = (WebServiceContext)ctx.lookup("java:comp/WebServiceContext");
        }
        catch (NamingException e) {
            throw new WebServiceException("Failed to lookup WebServiceContext", (Throwable)e);
        }
        this.annotationProcessor = new JAXWSAnnotationProcessor(new JNDIResolver(), wsContext);
        super.injectHandlers();
    }

    public void destroy() {
        this.destroyHandlers();
        super.destroy();
    }
}

