/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.builder;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.axis2.builder.Axis2Builder;
import org.apache.geronimo.axis2.client.Axis2ConfigGBean;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.jaxws.builder.JAXWSServiceRefBuilder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee.PortComponentRefType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ServiceRefBuilder
extends JAXWSServiceRefBuilder {
    private final Axis2Builder axis2Builder;
    public static final GBeanInfo GBEAN_INFO;

    public Axis2ServiceRefBuilder(Environment defaultEnvironment, String[] eeNamespaces, Axis2Builder axis2Builder) {
        super(defaultEnvironment, eeNamespaces);
        this.axis2Builder = axis2Builder;
    }

    public Object createService(ServiceRefType serviceRef, GerServiceRefType gerServiceRef, Module module, ClassLoader cl, Class serviceInterfaceClass, QName serviceQName, URI wsdlURI, Class serviceReferenceType, Map<Class, PortComponentRefType> portComponentRefMap) throws DeploymentException {
        this.registerConfigGBean(module);
        return this.axis2Builder.createService(serviceInterfaceClass, serviceReferenceType, wsdlURI, serviceQName, portComponentRefMap, serviceRef.getHandlerChains(), gerServiceRef, module, cl);
    }

    private void registerConfigGBean(Module module) throws DeploymentException {
        EARContext context = module.getEarContext();
        AbstractName containerFactoryName = context.getNaming().createChildName(module.getModuleName(), Axis2ConfigGBean.GBEAN_INFO.getName(), "GBean");
        try {
            context.getGBeanInstance(containerFactoryName);
        }
        catch (GBeanNotFoundException e1) {
            GBeanData configGBeanData = new GBeanData(containerFactoryName, Axis2ConfigGBean.GBEAN_INFO);
            configGBeanData.setAttribute("moduleName", (Object)module.getModuleName());
            try {
                context.addGBean(configGBeanData);
            }
            catch (GBeanAlreadyExistsException e) {
                throw new DeploymentException("Could not add config gbean", (Throwable)e);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(Axis2ServiceRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addInterface(ServiceRefBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.addReference("Axis2Builder", Axis2Builder.class, "ModuleBuilder");
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces", "Axis2Builder"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

