/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.axis.builder.AxisBuilder;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.j2ee.annotation.ReferenceType;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.HandlerInfoInfo;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.PortComponentRef;
import org.apache.openejb.jee.ServiceRef;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class AxisServiceRefBuilder
extends AbstractNamingBuilder
implements ServiceRefBuilder {
    private static final Logger log = LoggerFactory.getLogger(AxisServiceRefBuilder.class);
    private final QNameSet serviceRefQNameSet;
    private static final QName GER_SERVICE_REF_QNAME = GerServiceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_SERVICE_REF_QNAME_SET = QNameSet.singleton((QName)GER_SERVICE_REF_QNAME);
    private static final boolean JAX_RPC_CLIENT_SUPPORT;
    private final AxisBuilder axisBuilder;

    public AxisServiceRefBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="eeNamespaces") String[] eeNamespaces, @ParamReference(name="AxisBuilder", namingType="ModuleBuilder") AxisBuilder axisBuilder) {
        super(defaultEnvironment);
        this.axisBuilder = axisBuilder;
        this.serviceRefQNameSet = AxisServiceRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"service-ref");
    }

    protected boolean willMergeEnvironment(JndiConsumer specDD, XmlObject plan) {
        return !specDD.getServiceRef().isEmpty();
    }

    public void buildNaming(JndiConsumer jndiConsumer, XmlObject xmlObject, Module module, Map<EARContext.Key, Object> keyObjectMap) throws DeploymentException {
    }

    public void buildNaming(ServiceRef serviceRef, GerServiceRefType gerServiceRefType, Module module, Map<EARContext.Key, Object> sharedContext) throws DeploymentException {
        Class serviceInterface;
        if (!JAX_RPC_CLIENT_SUPPORT) {
            return;
        }
        String name = serviceRef.getKey();
        Bundle bundle = module.getEarContext().getDeploymentBundle();
        String serviceInterfaceName = serviceRef.getServiceInterface();
        AxisServiceRefBuilder.assureInterface((String)serviceInterfaceName, (String)"javax.xml.rpc.Service", (String)"[Web]Service", (Bundle)bundle);
        try {
            serviceInterface = bundle.loadClass(serviceInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load service interface class: " + serviceInterfaceName, (Throwable)e);
        }
        URI wsdlURI = null;
        if (serviceRef.getWsdlFile() != null) {
            try {
                wsdlURI = new URI(serviceRef.getWsdlFile());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("could not construct wsdl uri from " + serviceRef.getWsdlFile(), (Throwable)e);
            }
        }
        URI jaxrpcMappingURI = null;
        if (serviceRef.getJaxrpcMappingFile() != null) {
            try {
                jaxrpcMappingURI = new URI(serviceRef.getJaxrpcMappingFile());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not construct jaxrpc mapping uri from " + serviceRef.getJaxrpcMappingFile(), (Throwable)e);
            }
        }
        QName serviceQName = null;
        if (serviceRef.getServiceQname() != null) {
            serviceQName = serviceRef.getServiceQname();
        }
        HashMap<Class, String> portComponentRefMap = new HashMap<Class, String>();
        List portComponentRefs = serviceRef.getPortComponentRef();
        for (PortComponentRef portComponentRef : portComponentRefs) {
            Class serviceEndpointClass;
            String portComponentLink = portComponentRef.getPortComponentLink();
            String serviceEndpointInterfaceType = portComponentRef.getServiceEndpointInterface();
            AxisServiceRefBuilder.assureInterface((String)serviceEndpointInterfaceType, (String)"java.rmi.Remote", (String)"ServiceEndpoint", (Bundle)bundle);
            try {
                serviceEndpointClass = bundle.loadClass(serviceEndpointInterfaceType);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load service endpoint class " + serviceEndpointInterfaceType, (Throwable)e);
            }
            portComponentRefMap.put(serviceEndpointClass, portComponentLink);
        }
        List<HandlerInfoInfo> handlerInfos = AxisServiceRefBuilder.buildHandlerInfoList(serviceRef.getHandler(), bundle);
        Object ref = this.axisBuilder.createService(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, (Object)gerServiceRefType, module, bundle);
        this.put(name, ref, ReferenceType.SERVICE, module.getJndiContext(), serviceRef.getInjectionTarget(), sharedContext);
    }

    public QNameSet getSpecQNameSet() {
        return this.serviceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_SERVICE_REF_QNAME_SET;
    }

    private static List<HandlerInfoInfo> buildHandlerInfoList(List<Handler> handlers, Bundle bundle) throws DeploymentException {
        ArrayList<HandlerInfoInfo> handlerInfos = new ArrayList<HandlerInfoInfo>();
        for (Handler handler : handlers) {
            Class handlerClass;
            List portNames = handler.getPortName();
            String handlerClassName = handler.getHandlerClass();
            try {
                handlerClass = ClassLoading.loadClass((String)handlerClassName, (Bundle)bundle);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load handler class", (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            for (ParamValue paramValue : handler.getInitParam()) {
                config.put(paramValue.getParamName(), paramValue.getParamValue());
            }
            List headerQNames = handler.getSoapHeader();
            HashSet soapRoles = new HashSet(handler.getSoapRole());
            HandlerInfoInfo handlerInfoInfo = new HandlerInfoInfo(new HashSet(portNames), handlerClass, config, headerQNames, soapRoles);
            handlerInfos.add(handlerInfoInfo);
        }
        return handlerInfos;
    }

    private static Map mapServiceRefs(XmlObject[] refs) {
        HashMap<String, GerServiceRefType> refMap = new HashMap<String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = (GerServiceRefType)refs[i].copy().changeType(GerServiceRefType.type);
                String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }

    static {
        String webServiceServerSupported = System.getProperty("org.apache.geronimo.jaxrpc.client.support");
        if (webServiceServerSupported == null) {
            webServiceServerSupported = System.getProperty("org.apache.geronimo.jaxrpc.support");
        }
        JAX_RPC_CLIENT_SUPPORT = webServiceServerSupported == null ? true : Boolean.valueOf(webServiceServerSupported);
    }
}

