/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.soap.SOAPConstants;
import org.apache.geronimo.axis.client.OperationInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.webservices.builder.SchemaInfoBuilder;

public abstract class OperationDescBuilder {
    protected final OperationDesc operationDesc;
    protected final BindingOperation bindingOperation;
    protected final Operation operation;
    protected final String operationName;
    protected final Message input;
    protected final Message output;
    protected final SOAPOperation soapOperation;
    protected boolean built;

    public OperationDescBuilder(BindingOperation bindingOperation) throws DeploymentException {
        this.bindingOperation = bindingOperation;
        this.operation = bindingOperation.getOperation();
        this.soapOperation = (SOAPOperation)SchemaInfoBuilder.getExtensibilityElement((Class)SOAPOperation.class, (List)bindingOperation.getExtensibilityElements());
        this.operationDesc = new OperationDesc();
        this.output = this.operation.getOutput() == null ? null : this.operation.getOutput().getMessage();
        this.operationName = this.operation.getName();
        this.input = this.operation.getInput().getMessage();
    }

    public abstract OperationInfo buildOperationInfo(SOAPConstants var1) throws DeploymentException;

    public abstract OperationDesc buildOperationDesc() throws DeploymentException;

    protected QName getOperationNameFromSOAPBody() {
        BindingInput bindingInput = this.bindingOperation.getBindingInput();
        List extensibilityElements = bindingInput.getExtensibilityElements();
        Iterator iterator = extensibilityElements.iterator();
        while (iterator.hasNext()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (!(extensibilityElement instanceof SOAPBody)) continue;
            String namespaceURI = ((SOAPBody)extensibilityElement).getNamespaceURI();
            return new QName(namespaceURI, this.operationName);
        }
        return new QName("", this.operationName);
    }
}

