/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ResolverErrorAnalyzer {
    private BundleContext bundleContext;

    public ResolverErrorAnalyzer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private boolean hasPlatformAdmin() {
        try {
            this.bundleContext.getBundle().loadClass("org.eclipse.osgi.service.resolver.PlatformAdmin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getErrorsAsString(Collection<Bundle> bundles) {
        Collection<String> errors = this.getErrors(bundles);
        if (errors.isEmpty()) {
            return null;
        }
        String LF = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("The following problems were detected:").append(LF);
        Iterator<String> iterator = errors.iterator();
        while (iterator.hasNext()) {
            builder.append("    ");
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(LF);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getErrors(Collection<Bundle> bundles) {
        if (!this.hasPlatformAdmin()) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        ServiceReference ref = this.bundleContext.getServiceReference(PlatformAdmin.class.getName());
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.bundleContext.getService(ref);
            State systemState = platformAdmin.getState(false);
            ArrayList<BundleDescription> bundleDescriptions = new ArrayList<BundleDescription>(bundles.size());
            for (Bundle bundle : bundles) {
                BundleDescription bundleDescription = systemState.getBundle(bundle.getBundleId());
                if (bundleDescription == null) continue;
                bundleDescriptions.add(bundleDescription);
            }
            for (BundleDescription bundleDescription : bundleDescriptions) {
                this.collectErrors(bundleDescription, systemState, bundleDescriptions, errors);
            }
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
        return errors;
    }

    private void collectErrors(BundleDescription bundle, State state, List<BundleDescription> bundleDescriptions, Collection<String> errorList) {
        ResolverError[] errors;
        block5: for (ResolverError error : errors = state.getResolverErrors(bundle)) {
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            switch (error.getType()) {
                case 1: {
                    ImportPackageSpecification importPackageSpecification = (ImportPackageSpecification)constraint;
                    String resolution = (String)importPackageSpecification.getDirective("resolution");
                    if ("optional".equals(resolution) || "dynamic".equals(resolution) || ResolverErrorAnalyzer.isSatisfied(importPackageSpecification, bundleDescriptions) != null) continue block5;
                    errorList.add("The package dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)importPackageSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be satisfied.");
                    continue block5;
                }
                case 2: {
                    BundleSpecification bundleSpecification = (BundleSpecification)constraint;
                    if (bundleSpecification.isOptional() || ResolverErrorAnalyzer.isSatisfied((VersionConstraint)bundleSpecification, bundleDescriptions) != null) continue block5;
                    errorList.add("The bundle dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)bundleSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be satisfied.");
                    continue block5;
                }
                case 4: {
                    HostSpecification hostSpecification = (HostSpecification)constraint;
                    if (ResolverErrorAnalyzer.isSatisfied((VersionConstraint)hostSpecification, bundleDescriptions) != null) continue block5;
                    errorList.add("The host bundle dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)hostSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be satisfied.");
                    continue block5;
                }
                default: {
                    errorList.add(error.toString());
                }
            }
        }
    }

    private static ExportPackageDescription isSatisfied(ImportPackageSpecification importPackageSpecification, Collection<BundleDescription> bundleDescriptions) {
        for (BundleDescription b : bundleDescriptions) {
            ExportPackageDescription[] exportedPackages = b.getExportPackages();
            if (exportedPackages == null) continue;
            for (ExportPackageDescription exportedPackage : exportedPackages) {
                if (!importPackageSpecification.isSatisfiedBy((BaseDescription)exportedPackage)) continue;
                return exportedPackage;
            }
        }
        return null;
    }

    private static BundleDescription isSatisfied(VersionConstraint constraint, Collection<BundleDescription> bundleDescriptions) {
        for (BundleDescription b : bundleDescriptions) {
            if (!constraint.isSatisfiedBy((BaseDescription)b)) continue;
            return b;
        }
        return null;
    }

    private static String bundleToString(BundleDescription bundle) {
        return bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]";
    }

    private static String versionToString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null) {
            return constraint.getName();
        }
        String versionAttribute = constraint instanceof ImportPackageSpecification ? "version=\"" + versionRange + "\"" : "bundle-version=\"" + versionRange + "\"";
        return constraint.getName() + "; " + versionAttribute;
    }
}

