/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.activemq;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.geronimo.activemq.management.ActiveMQTransportConnector;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.AnnotationGBeanInfoFactory;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;

public class ActiveMQBrokerServiceMonitorGBean
implements GBeanLifecycle {
    private Kernel kernel;
    private Map<String, List<AbstractName>> brokerNameConnectorNamesMap = new ConcurrentHashMap<String, List<AbstractName>>();
    private BundleContext bundleContext;
    private AbstractName abstractName;
    private ServiceRegistration registration;

    public ActiveMQBrokerServiceMonitorGBean(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abstractName) {
        this.kernel = kernel;
        this.bundleContext = bundleContext;
        this.abstractName = abstractName;
    }

    public void doStart() throws Exception {
        BlueprintListener listener = new BlueprintListener(){

            public void blueprintEvent(BlueprintEvent event) {
                if (event.getType() == 2) {
                    ActiveMQBrokerServiceMonitorGBean.this.startConnectorGBeans(event.getBundle());
                } else if (event.getType() == 4) {
                    ActiveMQBrokerServiceMonitorGBean.this.stopConnectorGBeans(event.getBundle());
                }
            }
        };
        this.registration = this.bundleContext.registerService(BlueprintListener.class.getName(), (Object)listener, new Hashtable());
        this.startConnectorGBeans(null);
    }

    protected void startConnectorGBeans(Bundle bundle) {
        Set<BrokerService> brokerServices = this.getBrokerService(bundle);
        if (brokerServices == null) {
            return;
        }
        for (BrokerService brokerService : brokerServices) {
            if (!brokerService.isStarted()) continue;
            this.startConnectorWrapperGBeans(brokerService);
        }
    }

    protected void stopConnectorGBeans(Bundle bundle) {
        Set<BrokerService> brokerServices = this.getBrokerService(bundle);
        if (brokerServices == null) {
            return;
        }
        for (BrokerService brokerService : brokerServices) {
            this.stopConnectorWrapperGBeans(brokerService.getBrokerName());
        }
    }

    public void doStop() throws Exception {
        this.doFail();
    }

    public void doFail() {
        if (this.registration != null) {
            this.registration.unregister();
        }
        for (String brokerName : this.brokerNameConnectorNamesMap.keySet()) {
            this.stopConnectorWrapperGBeans(brokerName);
        }
        this.brokerNameConnectorNamesMap.clear();
    }

    protected void startConnectorWrapperGBeans(BrokerService brokerService) {
        try {
            List<AbstractName> oldConnectorNames = this.brokerNameConnectorNamesMap.get(brokerService.getBrokerName());
            if (oldConnectorNames != null) {
                return;
            }
            ArrayList<AbstractName> connectorNames = new ArrayList<AbstractName>();
            GBeanInfo gBeanInfo = new AnnotationGBeanInfoFactory().getGBeanInfo(ActiveMQTransportConnector.class);
            for (TransportConnector transportConnector : brokerService.getTransportConnectors()) {
                AbstractName connectorAbName = this.kernel.getNaming().createSiblingName(this.abstractName, transportConnector.getUri().toString().replace(':', '_'), "GBean");
                GBeanData gbeanData = new GBeanData(connectorAbName, gBeanInfo);
                gbeanData.setAttribute("transportConnector", (Object)transportConnector);
                this.kernel.loadGBean(gbeanData, this.bundleContext);
                this.kernel.startGBean(connectorAbName);
                connectorNames.add(connectorAbName);
            }
            this.brokerNameConnectorNamesMap.put(brokerService.getBrokerName(), connectorNames);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void stopConnectorWrapperGBeans(String brokerName) {
        List<AbstractName> connectorNames = this.brokerNameConnectorNamesMap.get(brokerName);
        if (connectorNames == null) {
            return;
        }
        for (AbstractName connectorName : connectorNames) {
            try {
                this.kernel.stopGBean(connectorName);
                this.kernel.unloadGBean(connectorName);
            }
            catch (Exception e) {}
        }
    }

    private Set<BrokerService> getBrokerService(Bundle bundle) {
        HashSet<BrokerService> brokerServices = new HashSet<BrokerService>();
        String targetBundleSymbolicName = "org.apache.geronimo.configs.activemq-broker-blueprint";
        try {
            if (bundle != null && !targetBundleSymbolicName.equals(bundle.getSymbolicName())) {
                return brokerServices;
            }
            String clazz = "org.osgi.service.blueprint.container.BlueprintContainer";
            String filter = "(osgi.blueprint.container.symbolicname=" + targetBundleSymbolicName + ")";
            ServiceReference[] references = this.bundleContext.getServiceReferences(clazz, filter);
            if (references != null) {
                for (ServiceReference reference : references) {
                    BlueprintContainer container = (BlueprintContainer)this.bundleContext.getService(reference);
                    Set ids = container.getComponentIds();
                    for (String id : ids) {
                        Object object = container.getComponentInstance(id);
                        if (!(object instanceof BrokerService)) continue;
                        brokerServices.add((BrokerService)object);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return brokerServices;
    }
}

