/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.deployment.service.ClassLoadingRulesUtil;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.ClassFilterType;
import org.apache.geronimo.deployment.xbeans.DependenciesType;
import org.apache.geronimo.deployment.xbeans.DependencyType;
import org.apache.geronimo.deployment.xbeans.EnvironmentDocument;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.ImportType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ClassLoadingRule;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class EnvironmentBuilder
extends PropertyEditorSupport
implements XmlAttributeBuilder {
    private static final QName QNAME = EnvironmentDocument.type.getDocumentElementName();
    private static final String NAMESPACE = QNAME.getNamespaceURI();

    public static Environment buildEnvironment(EnvironmentType environmentType) {
        Environment environment = new Environment();
        if (environmentType != null) {
            if (environmentType.isSetModuleId()) {
                environment.setConfigId(EnvironmentBuilder.toArtifact(environmentType.getModuleId(), null));
            }
            if (environmentType.isSetDependencies()) {
                DependencyType[] dependencyArray = environmentType.getDependencies().getDependencyArray();
                LinkedHashSet dependencies = EnvironmentBuilder.toDependencies(dependencyArray);
                environment.setDependencies((Collection)dependencies);
            }
            environment.setSuppressDefaultEnvironment(environmentType.isSetSuppressDefaultEnvironment());
            ClassLoadingRulesUtil.configureRules(environment.getClassLoadingRules(), environmentType);
        }
        return environment;
    }

    public static void mergeEnvironments(Environment environment, Environment additionalEnvironment) {
        if (additionalEnvironment != null) {
            if (environment.getConfigId() == null) {
                environment.setConfigId(additionalEnvironment.getConfigId());
            }
            environment.addDependencies((Collection)additionalEnvironment.getDependencies());
            environment.setSuppressDefaultEnvironment(environment.isSuppressDefaultEnvironment() || additionalEnvironment.isSuppressDefaultEnvironment());
            ClassLoadingRules classLoadingRules = environment.getClassLoadingRules();
            ClassLoadingRules additionalClassLoadingRules = additionalEnvironment.getClassLoadingRules();
            classLoadingRules.merge(additionalClassLoadingRules);
        }
    }

    public static Environment buildEnvironment(EnvironmentType environmentType, Environment defaultEnvironment) {
        Environment environment = EnvironmentBuilder.buildEnvironment(environmentType);
        if (!environment.isSuppressDefaultEnvironment()) {
            EnvironmentBuilder.mergeEnvironments(environment, defaultEnvironment);
        }
        return environment;
    }

    public static EnvironmentType buildEnvironmentType(Environment environment) {
        EnvironmentType environmentType = EnvironmentType.Factory.newInstance();
        if (environment.getConfigId() != null) {
            ArtifactType configId = EnvironmentBuilder.toArtifactType(environment.getConfigId());
            environmentType.setModuleId(configId);
        }
        List dependencies = EnvironmentBuilder.toDependencyTypes(environment.getDependencies());
        DependencyType[] dependencyTypes = dependencies.toArray(new DependencyType[dependencies.size()]);
        DependenciesType dependenciesType = environmentType.addNewDependencies();
        dependenciesType.setDependencyArray(dependencyTypes);
        ClassLoadingRules classLoadingRules = environment.getClassLoadingRules();
        if (classLoadingRules.isInverseClassLoading()) {
            environmentType.addNewInverseClassloading();
        }
        if (environment.isSuppressDefaultEnvironment()) {
            environmentType.addNewSuppressDefaultEnvironment();
        }
        ClassLoadingRule classLoadingRule = classLoadingRules.getHiddenRule();
        environmentType.setHiddenClasses(EnvironmentBuilder.toFilterType(classLoadingRule.getClassPrefixes()));
        classLoadingRule = classLoadingRules.getNonOverrideableRule();
        environmentType.setNonOverridableClasses(EnvironmentBuilder.toFilterType(classLoadingRule.getClassPrefixes()));
        classLoadingRule = classLoadingRules.getPrivateRule();
        environmentType.setPrivateClasses(EnvironmentBuilder.toFilterType(classLoadingRule.getClassPrefixes()));
        return environmentType;
    }

    private static ClassFilterType toFilterType(Set filters) {
        String[] classFilters = filters.toArray(new String[filters.size()]);
        ClassFilterType classFilter = ClassFilterType.Factory.newInstance();
        classFilter.setFilterArray(classFilters);
        return classFilter;
    }

    private static List toDependencyTypes(Collection artifacts) {
        ArrayList<DependencyType> dependencies = new ArrayList<DependencyType>();
        for (Dependency dependency : artifacts) {
            DependencyType artifactType = EnvironmentBuilder.toDependencyType(dependency);
            dependencies.add(artifactType);
        }
        return dependencies;
    }

    private static ArtifactType toArtifactType(Artifact artifact) {
        ArtifactType artifactType = ArtifactType.Factory.newInstance();
        EnvironmentBuilder.fillArtifactType(artifact, artifactType);
        return artifactType;
    }

    private static void fillArtifactType(Artifact artifact, ArtifactType artifactType) {
        if (artifact.getGroupId() != null) {
            artifactType.setGroupId(artifact.getGroupId());
        }
        if (artifact.getArtifactId() != null) {
            artifactType.setArtifactId(artifact.getArtifactId());
        }
        if (artifact.getVersion() != null) {
            artifactType.setVersion(artifact.getVersion().toString());
        }
        if (artifact.getType() != null) {
            artifactType.setType(artifact.getType());
        }
    }

    private static DependencyType toDependencyType(Dependency dependency) {
        DependencyType dependencyType = DependencyType.Factory.newInstance();
        EnvironmentBuilder.fillArtifactType(dependency.getArtifact(), dependencyType);
        org.apache.geronimo.kernel.repository.ImportType importType = dependency.getImportType();
        if (importType == org.apache.geronimo.kernel.repository.ImportType.CLASSES) {
            dependencyType.setImport(ImportType.CLASSES);
        } else if (importType == org.apache.geronimo.kernel.repository.ImportType.SERVICES) {
            dependencyType.setImport(ImportType.SERVICES);
        }
        return dependencyType;
    }

    private static Set toFilters(ClassFilterType filterType) {
        HashSet<String> filters = new HashSet<String>();
        if (filterType != null) {
            String[] filterArray = filterType.getFilterArray();
            for (int i = 0; i < filterArray.length; ++i) {
                String filter = filterArray[i].trim();
                filters.add(filter);
            }
        }
        return filters;
    }

    static LinkedHashSet toArtifacts(ArtifactType[] artifactTypes) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (int i = 0; i < artifactTypes.length; ++i) {
            ArtifactType artifactType = artifactTypes[i];
            Artifact artifact = EnvironmentBuilder.toArtifact(artifactType, "jar");
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private static LinkedHashSet toDependencies(DependencyType[] dependencyArray) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (int i = 0; i < dependencyArray.length; ++i) {
            DependencyType artifactType = dependencyArray[i];
            Dependency dependency = EnvironmentBuilder.toDependency(artifactType);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static Dependency toDependency(DependencyType dependencyType) {
        Artifact artifact = EnvironmentBuilder.toArtifact(dependencyType, null);
        if (((Object)((Object)ImportType.CLASSES)).equals((Object)dependencyType.getImport())) {
            return new Dependency(artifact, org.apache.geronimo.kernel.repository.ImportType.CLASSES);
        }
        if (((Object)((Object)ImportType.SERVICES)).equals((Object)dependencyType.getImport())) {
            return new Dependency(artifact, org.apache.geronimo.kernel.repository.ImportType.SERVICES);
        }
        if (dependencyType.getImport() == null) {
            return new Dependency(artifact, org.apache.geronimo.kernel.repository.ImportType.ALL);
        }
        throw new IllegalArgumentException("Unknown import type: " + (Object)((Object)dependencyType.getImport()));
    }

    private static Artifact toArtifact(ArtifactType artifactType, String defaultType) {
        String groupId = artifactType.isSetGroupId() ? EnvironmentBuilder.trim(artifactType.getGroupId()) : null;
        String type = artifactType.isSetType() ? EnvironmentBuilder.trim(artifactType.getType()) : defaultType;
        String artifactId = EnvironmentBuilder.trim(artifactType.getArtifactId());
        String version = artifactType.isSetVersion() ? EnvironmentBuilder.trim(artifactType.getVersion()) : null;
        return new Artifact(groupId, artifactId, version, type);
    }

    private static String trim(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string.trim();
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public Object getValue(XmlObject xmlObject, String type, ClassLoader cl) throws DeploymentException {
        EnvironmentType environmentType = xmlObject instanceof EnvironmentType ? (EnvironmentType)xmlObject : (EnvironmentType)xmlObject.copy().changeType(EnvironmentType.type);
        try {
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setLoadLineNumbers();
            ArrayList errors = new ArrayList();
            xmlOptions.setErrorListener(errors);
            if (!environmentType.validate(xmlOptions)) {
                throw new XmlException("Invalid deployment descriptor: " + errors + "\nDescriptor: " + environmentType.toString(), null, errors);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        return EnvironmentBuilder.buildEnvironment(environmentType);
    }

    public String getAsText() {
        Environment environment = (Environment)this.getValue();
        EnvironmentType environmentType = EnvironmentBuilder.buildEnvironmentType(environment);
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setSaveSyntheticDocumentElement(QNAME);
        xmlOptions.setSavePrettyPrint();
        return environmentType.xmlText(xmlOptions);
    }

    public void setAsText(String text) {
        try {
            EnvironmentDocument environmentDocument = EnvironmentDocument.Factory.parse(text);
            EnvironmentType environmentType = environmentDocument.getEnvironment();
            Environment environment = (Environment)this.getValue(environmentType, null, null);
            this.setValue(environment);
        }
        catch (XmlException e) {
            throw new PropertyEditorException((Throwable)e);
        }
        catch (DeploymentException e) {
            throw new PropertyEditorException((Throwable)e);
        }
    }
}

