/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.deployment.xbeans.ClassFilterType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.kernel.repository.ClassLoadingRule;
import org.apache.geronimo.kernel.repository.ClassLoadingRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLoadingRulesUtil {
    private ClassLoadingRulesUtil() {
    }

    public static void configureRules(ClassLoadingRules classLoadingRules, EnvironmentType environmentType) {
        classLoadingRules.setInverseClassLoading(environmentType.isSetInverseClassloading());
        if (null != environmentType.getHiddenClasses()) {
            ClassLoadingRule hiddenRule = classLoadingRules.getHiddenRule();
            hiddenRule.setClassPrefixes(ClassLoadingRulesUtil.toFilters(environmentType.getHiddenClasses()));
        }
        if (null != environmentType.getNonOverridableClasses()) {
            ClassLoadingRule nonOverrideableRule = classLoadingRules.getNonOverrideableRule();
            nonOverrideableRule.setClassPrefixes(ClassLoadingRulesUtil.toFilters(environmentType.getNonOverridableClasses()));
        }
        if (null != environmentType.getPrivateClasses()) {
            ClassLoadingRule privateRule = classLoadingRules.getPrivateRule();
            privateRule.setClassPrefixes(ClassLoadingRulesUtil.toFilters(environmentType.getPrivateClasses()));
        }
    }

    private static Set<String> toFilters(ClassFilterType filterType) {
        HashSet<String> filters = new HashSet<String>();
        if (null != filterType) {
            String[] filterArray;
            for (String filter : filterArray = filterType.getFilterArray()) {
                filter = filter.trim();
                filters.add(filter);
            }
        }
        return filters;
    }
}

