/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.propertyeditor.PropertyEditorException;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.deployment.javabean.xbeans.BeanPropertyType;
import org.apache.geronimo.deployment.javabean.xbeans.JavabeanDocument;
import org.apache.geronimo.deployment.javabean.xbeans.JavabeanType;
import org.apache.geronimo.deployment.javabean.xbeans.PropertyType;
import org.apache.geronimo.deployment.service.DoNotPersist;
import org.apache.geronimo.deployment.service.EncryptOnPersist;
import org.apache.geronimo.deployment.service.JavaBeanXmlAttributeBuilder;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class JavaBeanXmlAttributeEditor
extends PropertyEditorSupport {
    private static final QName QNAME = JavabeanDocument.type.getDocumentElementName();
    private static final Class[] PRIMITIVES_CLASSES = new Class[]{String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    private final Class javaBeanClazz;
    private final XmlAttributeBuilder xmlAttributeBuilder;

    public JavaBeanXmlAttributeEditor(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz is required");
        }
        this.javaBeanClazz = clazz;
        this.xmlAttributeBuilder = this.newXmlAttributeBuilder();
    }

    protected JavaBeanXmlAttributeBuilder newXmlAttributeBuilder() {
        return new JavaBeanXmlAttributeBuilder();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            JavabeanDocument document = JavabeanDocument.Factory.parse(text);
            JavabeanType javaBeanType = document.getJavabean();
            PropertyType[] pt = javaBeanType.getPropertyArray();
            for (int i = 0; i < pt.length; ++i) {
                if (!javaBeanType.getPropertyArray()[i].getName().endsWith("Password") && !javaBeanType.getPropertyArray()[i].getName().endsWith("password")) continue;
                String decryptedValue = (String)((Object)EncryptionManager.decrypt((String)javaBeanType.getPropertyArray()[i].getStringValue()));
                javaBeanType.getPropertyArray()[i].setStringValue(decryptedValue);
            }
            Object javabean = this.xmlAttributeBuilder.getValue(javaBeanType, this.javaBeanClazz.getName(), this.getClass().getClassLoader());
            this.setValue(javabean);
        }
        catch (XmlException e) {
            throw new PropertyEditorException((Throwable)e);
        }
        catch (DeploymentException e) {
            throw new PropertyEditorException((Throwable)e);
        }
    }

    public String getAsText() {
        JavabeanType javabeanType = this.getJavabeanType(this.getValue());
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setSaveSyntheticDocumentElement(QNAME);
        xmlOptions.setSavePrettyPrint();
        return javabeanType.xmlText(xmlOptions);
    }

    protected JavabeanType getJavabeanType(Object javaBean) {
        PropertyDescriptor[] propertyDescriptors;
        JavabeanType javabeanType = JavabeanType.Factory.newInstance();
        javabeanType.setClass1(javaBean.getClass().getName());
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(javaBean.getClass());
            propertyDescriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("See nested", e);
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            this.handle(javaBean, propertyDescriptor, javabeanType);
        }
        return javabeanType;
    }

    protected void handle(Object javaBean, PropertyDescriptor propertyDescriptor, JavabeanType javabeanType) {
        Object value;
        Method readMethod = propertyDescriptor.getReadMethod();
        if (null == readMethod) {
            return;
        }
        if (readMethod.isAnnotationPresent(DoNotPersist.class) || readMethod.getName().equals("getClass")) {
            return;
        }
        try {
            value = readMethod.invoke(javaBean, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("See nested", e);
        }
        if (null == value) {
            return;
        }
        if (this.isPrimitive(value)) {
            PropertyType propertyType = javabeanType.addNewProperty();
            propertyType.setName(propertyDescriptor.getName());
            String valueAsString = value.toString();
            if (readMethod.isAnnotationPresent(EncryptOnPersist.class)) {
                valueAsString = EncryptionManager.encrypt((Serializable)((Object)valueAsString));
            }
            propertyType.setStringValue(valueAsString);
        } else {
            JavabeanType nestedJavabeanType = this.getJavabeanType(value);
            BeanPropertyType propertyType = javabeanType.addNewBeanProperty();
            propertyType.setName(propertyDescriptor.getName());
            propertyType.setJavabean(nestedJavabeanType);
        }
    }

    protected boolean isPrimitive(Object propertyValue) {
        Class<?> valueClass = propertyValue.getClass();
        for (Class primitiveClass : PRIMITIVES_CLASSES) {
            if (!valueClass.equals(primitiveClass)) continue;
            return true;
        }
        return false;
    }
}

