/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.naming.ResourceSource;
import org.apache.geronimo.naming.reference.BundleAwareReference;
import org.apache.geronimo.naming.reference.KernelAwareReference;
import org.apache.xbean.naming.reference.SimpleReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReference<E extends Throwable>
extends SimpleReference
implements BundleAwareReference,
KernelAwareReference {
    private static final Logger logger = LoggerFactory.getLogger(ResourceReference.class);
    private final String type;
    private String query;
    private AbstractName gbeanName;
    private transient BundleContext bundleContext;

    public ResourceReference(AbstractName gbeanName, String type) {
        this.gbeanName = gbeanName;
        this.type = type;
    }

    public ResourceReference(String query, String type) {
        this.query = query;
        this.type = type;
    }

    public Object getContent() throws NamingException {
        Object object;
        block6: {
            ServiceReference ref = null;
            try {
                ServiceReference[] refs = this.bundleContext.getServiceReferences(ResourceSource.class.getName(), this.query);
                if (refs == null || refs.length == 0) {
                    throw new NameNotFoundException("could not locate osgi service matching " + this.query);
                }
                ref = refs[0];
                ResourceSource source = (ResourceSource)this.bundleContext.getService(ref);
                object = source.$getResource();
                if (ref == null) break block6;
            }
            catch (Throwable e) {
                try {
                    throw (NamingException)new NamingException("Could not create resource").initCause(e);
                }
                catch (Throwable throwable) {
                    if (ref != null) {
                        this.bundleContext.ungetService(ref);
                    }
                    throw throwable;
                }
            }
            this.bundleContext.ungetService(ref);
        }
        return object;
    }

    public String getClassName() {
        return this.type;
    }

    @Override
    public void setBundle(Bundle bundle) {
        this.bundleContext = bundle.getBundleContext();
    }

    @Override
    public void setKernel(Kernel kernel) {
        if (this.query == null) {
            try {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
                AbstractName mappedAbstractName = new AbstractName(configurationManager.getArtifactResolver().resolveInClassLoader(this.gbeanName.getArtifact()), this.gbeanName.getName());
                String osgiJndiName = kernel.getNaming().toOsgiJndiName(mappedAbstractName);
                this.query = "(osgi.jndi.service.name=" + osgiJndiName + ')';
            }
            catch (GBeanNotFoundException e) {
                logger.error("Fail to build the jndi name for " + this.gbeanName, (Throwable)e);
            }
            catch (MissingDependencyException e) {
                logger.error("Fail to build the jndi name for " + this.gbeanName, (Throwable)e);
            }
        }
    }
}

