/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.naming.reference.KernelAwareReference;
import org.apache.geronimo.naming.reference.SimpleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiReference
extends SimpleReference
implements KernelAwareReference {
    private static final Logger logger = LoggerFactory.getLogger(JndiReference.class);
    private String jndiName;
    private AbstractName gbeanName;
    private String prefix;

    public JndiReference(String jndiName) {
        this.jndiName = jndiName;
    }

    public JndiReference(String prefix, AbstractName gbeanName) {
        this.gbeanName = gbeanName;
        this.prefix = prefix;
    }

    public Object getContent() throws NamingException {
        InitialContext ctx = new InitialContext();
        return ctx.lookup(this.jndiName);
    }

    @Override
    public void setKernel(Kernel kernel) {
        if (this.jndiName == null) {
            try {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
                AbstractName mappedAbstractName = new AbstractName(configurationManager.getArtifactResolver().resolveInClassLoader(this.gbeanName.getArtifact()), this.gbeanName.getName());
                String osgiJndiName = kernel.getNaming().toOsgiJndiName(mappedAbstractName);
                this.jndiName = this.prefix + osgiJndiName;
            }
            catch (GBeanNotFoundException e) {
                logger.error("Fail to build the jndi name for " + this.gbeanName, (Throwable)e);
            }
            catch (MissingDependencyException e) {
                logger.error("Fail to build the jndi name for " + this.gbeanName, (Throwable)e);
            }
        }
    }
}

