/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.GBeanState;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.xstream.XStreamUtil;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamGBeanState
implements GBeanState {
    private final List<GBeanData> gbeans = new ArrayList<GBeanData>();
    private Element gbeanState;

    public XStreamGBeanState(Element gbeanState) {
        this.gbeanState = gbeanState;
    }

    public XStreamGBeanState(Collection<GBeanData> gbeans) {
        if (gbeans != null) {
            this.gbeans.addAll(gbeans);
        }
    }

    public Element getGBeanState() throws IOException {
        if (this.gbeanState == null) {
            this.gbeanState = XStreamGBeanState.storeGBeans(this.gbeans);
            this.gbeans.clear();
        }
        return this.gbeanState;
    }

    @Override
    public List<GBeanData> getGBeans(ClassLoader classLoader) throws InvalidConfigException {
        if (this.gbeanState == null) {
            return Collections.unmodifiableList(this.gbeans);
        }
        this.gbeans.addAll(XStreamGBeanState.loadGBeans(this.gbeanState, classLoader));
        return Collections.unmodifiableList(this.gbeans);
    }

    @Override
    public void addGBean(GBeanData gbeanData) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        this.gbeans.add(gbeanData);
    }

    @Override
    public GBeanData addGBean(String name, GBeanInfo gbeanInfo, Naming naming, Environment environment) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        String j2eeType = gbeanInfo.getJ2eeType();
        if (j2eeType == null) {
            j2eeType = "GBean";
        }
        AbstractName abstractName = naming.createRootName(environment.getConfigId(), name, j2eeType);
        GBeanData gBeanData = new GBeanData(abstractName, gbeanInfo);
        this.addGBean(gBeanData);
        return gBeanData;
    }

    @Override
    public GBeanData addGBean(String name, Class gbeanClass, Naming naming, Environment environment) {
        if (this.gbeanState != null) {
            throw new IllegalStateException("GBeans have been serialized, so no more GBeans can be added");
        }
        GBeanData gBeanData = new GBeanData(gbeanClass);
        String j2eeType = gBeanData.getGBeanInfo().getJ2eeType();
        if (j2eeType == null) {
            j2eeType = "GBean";
        }
        AbstractName abstractName = naming.createRootName(environment.getConfigId(), name, j2eeType);
        gBeanData.setAbstractName(abstractName);
        this.addGBean(gBeanData);
        return gBeanData;
    }

    private static List<GBeanData> loadGBeans(Element element, ClassLoader classLoader) throws InvalidConfigException {
        if (element != null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                DomReader reader = new DomReader(element);
                XStream xstream = XStreamUtil.createXStream();
                xstream.setClassLoader(classLoader);
                Object o = xstream.unmarshal((HierarchicalStreamReader)reader);
                GBeanData[] gbeanDatas = (GBeanData[])o;
                List<GBeanData> list = Arrays.asList(gbeanDatas);
                return list;
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to load gbeans", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        return Collections.emptyList();
    }

    private static Element storeGBeans(List<GBeanData> gbeans) throws IOException {
        DocumentBuilder documentBuilder;
        GBeanData[] gbeanDatas = gbeans.toArray(new GBeanData[gbeans.size()]);
        DocumentBuilderFactory documentBuilderFactory = XmlUtil.newDocumentBuilderFactory();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("Cannot instantiate " + Document.class.getName()).initCause(e);
        }
        Document document = documentBuilder.newDocument();
        DomWriter writer = new DomWriter(document);
        XStream xstream = XStreamUtil.createXStream();
        xstream.marshal((Object)gbeanDatas, (HierarchicalStreamWriter)writer);
        return document.getDocumentElement();
    }
}

