/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geronimo.gbean.BasicGBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanInfoFactoryException;
import org.apache.geronimo.gbean.GBeanInfoFactoryRegistry;
import org.apache.geronimo.gbean.annotation.AnnotationGBeanInfoFactory;

public class MultiGBeanInfoFactory
implements GBeanInfoFactory,
GBeanInfoFactoryRegistry {
    private static final CopyOnWriteArrayList<GBeanInfoFactory> FACTORIES = new CopyOnWriteArrayList();

    public void registerFactory(GBeanInfoFactory factory) {
        FACTORIES.add(0, factory);
    }

    public void unregisterFactory(GBeanInfoFactory factory) {
        FACTORIES.remove(factory);
    }

    public GBeanInfo getGBeanInfo(Class clazz) throws GBeanInfoFactoryException {
        for (GBeanInfoFactory factory : FACTORIES) {
            try {
                return factory.getGBeanInfo(clazz);
            }
            catch (GBeanInfoFactoryException e) {
            }
        }
        throw new GBeanInfoFactoryException("Cannot create a GBeanInfo for [" + clazz + "]");
    }

    public GBeanInfo getGBeanInfo(String className, ClassLoader classLoader) throws GBeanInfoFactoryException {
        for (GBeanInfoFactory factory : FACTORIES) {
            try {
                return factory.getGBeanInfo(className, classLoader);
            }
            catch (GBeanInfoFactoryException e) {
            }
        }
        throw new GBeanInfoFactoryException("Cannot create a GBeanInfo for [" + className + "]");
    }

    static {
        FACTORIES.add(new BasicGBeanInfoFactory());
        FACTORIES.add(new AnnotationGBeanInfoFactory());
    }
}

