/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcLeakPreventionListener
implements BundleListener {
    private static final Logger logger = LoggerFactory.getLogger(JdbcLeakPreventionListener.class);

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            Bundle bundle = event.getBundle();
            JdbcLeakPreventionListener.unRegisterJdbcDrivers(bundle);
        }
    }

    public static void unRegisterJdbcDrivers(Bundle bundle) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            Bundle driverBundle = BundleUtils.getBundle((ClassLoader)driver.getClass().getClassLoader(), (boolean)true);
            if (driverBundle != bundle) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (Exception e) {
                logger.warn("Fail to unregister the driver " + driver.getClass().getName(), (Throwable)e);
            }
        }
    }
}

