/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.jdbc.DelegatingDriver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDriverExtender
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseDriverExtender.class);
    private BundleTracker tracker;

    public void start(BundleContext context) throws Exception {
        this.tracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)new DriverBundleTrackerCustomizer());
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
        DriverManager.deregisterDriver(DelegatingDriver.DELEGATINGDRIVER_INSTANCE);
    }

    private static List<Driver> loadDrivers(Bundle bundle, URL providerURL) {
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(providerURL.openStream()));
            while ((line = in.readLine()) != null) {
                line = line.trim();
                try {
                    Class driverClass = bundle.loadClass(line);
                    drivers.add((Driver)driverClass.newInstance());
                }
                catch (Exception e) {
                    LOG.warn("Failed to load driver {}", (Object)line, (Object)e);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Error reading {} service file", (Object)providerURL);
        }
        return drivers;
    }

    private static void register(List<Driver> drivers) {
        for (Driver driver : drivers) {
            DelegatingDriver.registerDriver(driver);
        }
    }

    private static void unregister(List<Driver> drivers) {
        for (Driver driver : drivers) {
            DelegatingDriver.unregisterDriver(driver);
        }
    }

    private static class DriverBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        private DriverBundleTrackerCustomizer() {
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            URL providerURL = bundle.getEntry("META-INF/services/java.sql.Driver");
            if (providerURL != null) {
                List drivers = DatabaseDriverExtender.loadDrivers(bundle, providerURL);
                DatabaseDriverExtender.register(drivers);
                LOG.debug("Registered {} drivers in bundle {}", (Object)drivers, (Object)bundle);
                return drivers;
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            List drivers = (List)object;
            DatabaseDriverExtender.unregister(drivers);
            LOG.debug("Unregistered {} drivers in bundle {}", (Object)drivers, (Object)bundle);
        }
    }
}

