/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.IllegalConfigurationException;
import org.apache.geronimo.deployment.ClassPathUtils;
import org.apache.geronimo.deployment.CopyResourceContext;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.deployment.DeploymentConfigurationManager;
import org.apache.geronimo.deployment.InPlaceResourceContext;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.deployment.util.osgi.DummyExportPackagesSelector;
import org.apache.geronimo.deployment.util.osgi.OSGiMetaDataBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.Manifest;
import org.apache.geronimo.kernel.config.ManifestException;
import org.apache.geronimo.kernel.osgi.ConfigurationActivator;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.system.plugin.model.ArtifactType;
import org.apache.geronimo.system.plugin.model.DependencyType;
import org.apache.geronimo.system.plugin.model.PluginArtifactType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentContext {
    private static final Logger log = LoggerFactory.getLogger(DeploymentContext.class);
    protected final File baseDir;
    protected final File inPlaceConfigurationDir;
    protected final ResourceContext resourceContext;
    protected final Map<String, ConfigurationData> childConfigurationDatas = new LinkedHashMap<String, ConfigurationData>();
    protected final ConfigurationManager configurationManager;
    protected final Naming naming;
    protected final List<ConfigurationData> additionalDeployment = new ArrayList<ConfigurationData>();
    protected final AbstractName moduleName;
    protected final LinkedHashSet<String> bundleClassPath = new LinkedHashSet();
    protected final ConfigurationModuleType moduleType;
    protected final Environment environment;
    private final BundleContext bundleContext;
    protected Configuration configuration;
    private Bundle tempBundle;

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, Collection<Repository> repositories, BundleContext bundleContext) throws DeploymentException {
        this(baseDir, inPlaceConfigurationDir, environment, moduleName, moduleType, naming, DeploymentContext.createConfigurationManager(configurationManager, repositories, bundleContext), bundleContext);
    }

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, BundleContext bundleContext) throws DeploymentException {
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (moduleType == null) {
            throw new NullPointerException("type is null");
        }
        if (configurationManager == null) {
            throw new NullPointerException("configurationManager is null");
        }
        if (baseDir == null) {
            throw new NullPointerException("baseDir is null");
        }
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new DeploymentException("Could not create directory for deployment context assembly: " + baseDir);
        }
        if (bundleContext == null) {
            throw new NullPointerException("no bundle context");
        }
        this.baseDir = baseDir;
        this.inPlaceConfigurationDir = inPlaceConfigurationDir;
        this.moduleName = moduleName;
        this.naming = naming;
        this.moduleType = moduleType;
        this.environment = environment;
        this.configurationManager = DeploymentContext.createConfigurationManager(configurationManager, Collections.<Repository>emptyList(), bundleContext);
        this.bundleContext = bundleContext;
        this.resourceContext = null == inPlaceConfigurationDir ? new CopyResourceContext(this, baseDir) : new InPlaceResourceContext(this, inPlaceConfigurationDir);
    }

    protected DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, ResourceContext resourceContext, BundleContext bundleContext) throws DeploymentException {
        if (bundleContext == null) {
            throw new NullPointerException("no bundle context");
        }
        this.baseDir = baseDir;
        this.inPlaceConfigurationDir = inPlaceConfigurationDir;
        this.moduleName = moduleName;
        this.naming = naming;
        this.moduleType = moduleType;
        this.environment = environment;
        this.configurationManager = DeploymentContext.createConfigurationManager(configurationManager, Collections.<Repository>emptyList(), bundleContext);
        this.resourceContext = resourceContext;
        this.bundleContext = bundleContext;
    }

    private static ConfigurationManager createConfigurationManager(ConfigurationManager configurationManager, Collection<Repository> repositories, BundleContext bundleContext) {
        if (configurationManager instanceof DeploymentConfigurationManager) {
            return configurationManager;
        }
        return new DeploymentConfigurationManager(configurationManager, repositories, bundleContext);
    }

    public void initializeConfiguration() throws DeploymentException {
        this.configuration = this.createTempConfiguration();
    }

    private Configuration createTempConfiguration() throws DeploymentException {
        Object resolvedParentIds = null;
        try {
            ConfigurationData configurationData = new ConfigurationData(this.moduleType, null, this.childConfigurationDatas, this.environment, this.baseDir, this.inPlaceConfigurationDir, this.naming);
            this.createTempManifest();
            this.createPluginMetadata();
            String location = BundleUtils.toReferenceFileLocation((File)this.getConfigurationDir());
            this.tempBundle = this.bundleContext.installBundle(location);
            if (BundleUtils.canStart((Bundle)this.tempBundle)) {
                this.tempBundle.start(1);
            }
            configurationData.setBundleContext(this.tempBundle.getBundleContext());
            this.configurationManager.loadConfiguration(configurationData);
            return this.configurationManager.getConfiguration(this.environment.getConfigId());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to create configuration for deployment: dependencies: " + resolvedParentIds, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPluginMetadata() throws IOException, JAXBException, XMLStreamException {
        PluginType pluginType = this.getPluginMetadata();
        File metaInf = new File(this.getConfigurationDir(), "META-INF");
        metaInf.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(metaInf, "geronimo-plugin.xml"));
        try {
            PluginXmlUtil.writePluginMetadata((PluginType)pluginType, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public PluginType getPluginMetadata() {
        PluginType pluginType = new PluginType();
        pluginType.setName("Temporary Plugin metadata for deployment");
        PluginArtifactType instance = new PluginArtifactType();
        instance.setModuleId(ArtifactType.newArtifactType((Artifact)this.environment.getConfigId()));
        List dependenciees = instance.getDependency();
        for (Dependency dependency : this.environment.getDependencies()) {
            dependenciees.add(DependencyType.newDependencyType((Dependency)dependency));
        }
        pluginType.getPluginArtifact().add(instance);
        return pluginType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempManifest() throws DeploymentException, IOException {
        Manifest manifest;
        Environment env = new Environment(this.environment);
        Artifact id = env.getConfigId();
        env.setConfigId(new Artifact(id.getGroupId(), id.getArtifactId() + "-DEPLOYMENT", id.getVersion(), id.getType()));
        env.addToBundleClassPath(this.bundleClassPath);
        env.setBundleActivator(null);
        env.addDynamicImportPackage("*");
        OSGiMetaDataBuilder osgiMetaDataBuilder = new OSGiMetaDataBuilder(this.bundleContext, new DummyExportPackagesSelector());
        try {
            osgiMetaDataBuilder.build(env);
        }
        catch (IllegalConfigurationException e) {
            throw new DeploymentException((Throwable)e);
        }
        try {
            manifest = env.getManifest();
        }
        catch (ManifestException e) {
            throw new DeploymentException((Throwable)e);
        }
        File metaInf = new File(this.getConfigurationDir(), "META-INF");
        metaInf.mkdirs();
        FileWriter fw = new FileWriter(new File(metaInf, "MANIFEST.MF"));
        PrintWriter pw = new PrintWriter(fw);
        try {
            manifest.write(pw);
        }
        finally {
            pw.close();
            fw.close();
        }
    }

    private File getConfigurationDir() {
        return this.inPlaceConfigurationDir == null ? this.baseDir : this.inPlaceConfigurationDir;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Artifact getConfigID() {
        return this.environment.getConfigId();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getInPlaceConfigurationDir() {
        return this.inPlaceConfigurationDir;
    }

    public LinkedHashSet<String> getBundleClassPath() {
        return new LinkedHashSet<String>(this.bundleClassPath);
    }

    public Naming getNaming() {
        return this.naming;
    }

    public GBeanData addGBean(String name, GBeanInfo gbeanInfo) throws GBeanAlreadyExistsException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanInfo == null) {
            throw new NullPointerException("gbean is null");
        }
        GBeanData gbean = new GBeanData(gbeanInfo);
        this.configuration.addGBean(name, gbean);
        return gbean;
    }

    public void addGBean(GBeanData gbean) throws GBeanAlreadyExistsException {
        if (gbean == null) {
            throw new NullPointerException("gbean is null");
        }
        if (gbean.getAbstractName() == null) {
            throw new NullPointerException("gbean.getAbstractName() is null");
        }
        this.configuration.addGBean(gbean);
    }

    public void removeGBean(AbstractName name) throws GBeanNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.configuration.removeGBean(name);
    }

    public Set<AbstractName> getGBeanNames() {
        return new HashSet<AbstractName>(this.configuration.getGBeans().keySet());
    }

    public Set<AbstractName> listGBeans(AbstractNameQuery pattern) {
        return this.findGBeans(pattern);
    }

    public AbstractName findGBean(AbstractNameQuery pattern) throws GBeanNotFoundException {
        return this.configuration.findGBean(pattern);
    }

    public AbstractName findGBean(Set<AbstractNameQuery> patterns) throws GBeanNotFoundException {
        return this.configuration.findGBean(patterns);
    }

    public LinkedHashSet<AbstractName> findGBeans(AbstractNameQuery pattern) {
        return this.configuration.findGBeans(pattern);
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Set<AbstractNameQuery> patterns) {
        return this.configuration.findGBeanDatas(patterns);
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Configuration configuration, AbstractNameQuery pattern) {
        return configuration.findGBeanDatas(configuration, Collections.singleton(pattern));
    }

    public LinkedHashSet<AbstractName> findGBeans(Set<AbstractNameQuery> patterns) {
        return this.configuration.findGBeans(patterns);
    }

    public GBeanData getGBeanInstance(AbstractName name) throws GBeanNotFoundException {
        Map gbeans = this.configuration.getGBeans();
        GBeanData gbeanData = (GBeanData)gbeans.get(name);
        if (gbeanData == null) {
            throw new GBeanNotFoundException(name);
        }
        return gbeanData;
    }

    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        this.resourceContext.addIncludeAsPackedJar(targetPath, jarFile);
    }

    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addInclude(targetPath, zipFile, zipEntry);
    }

    public void addInclude(URI targetPath, URL source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void addInclude(URI targetPath, File source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void getCompleteManifestClassPath(Deployable deployable, URI moduleBaseUri, URI resolutionUri, Collection<String> classpath, Collection<String> exclusions) throws DeploymentException {
        if (!(deployable instanceof DeployableJarFile)) {
            throw new IllegalArgumentException("Expected DeployableJarFile");
        }
        JarFile moduleFile = ((DeployableJarFile)deployable).getJarFile();
        ClassPathUtils.getCompleteManifestClassPath(moduleFile, moduleBaseUri, resolutionUri, classpath, exclusions, new DefaultJarFileFactory());
    }

    public void addManifestClassPath(JarFile moduleFile, URI moduleBaseUri, Collection<String> manifestClasspath) throws DeploymentException {
        ClassPathUtils.addManifestClassPath(moduleFile, moduleBaseUri, manifestClasspath, new DefaultJarFileFactory());
    }

    public void addToClassPath(String target) {
        this.bundleClassPath.add(target);
    }

    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addFile(targetPath, zipFile, zipEntry);
    }

    public void addFile(URI targetPath, URL source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, File source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, String source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public File getTargetFile(URI targetPath) {
        return this.resourceContext.getTargetFile(targetPath);
    }

    public URL getTargetURL(URI targetPath) {
        return this.resourceContext.getTargetURL(targetPath);
    }

    public Bundle getDeploymentBundle() throws DeploymentException {
        return this.configuration.getBundle();
    }

    public ConfigurationModuleType getModuleType() {
        return this.moduleType;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException("configuration not initialized");
        }
        return this.configuration;
    }

    public void flush() throws IOException {
        this.resourceContext.flush();
    }

    public void close() throws IOException, DeploymentException {
        if (this.configurationManager != null && this.configuration != null) {
            try {
                this.configurationManager.unloadConfiguration(this.configuration.getId());
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (this.tempBundle != null) {
            try {
                this.tempBundle.uninstall();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
    }

    public void addChildConfiguration(String moduleName, ConfigurationData configurationData) {
        this.childConfigurationDatas.put(moduleName, configurationData);
    }

    public ConfigurationData getConfigurationData() throws DeploymentException {
        List<String> failures = this.verify(this.configuration);
        if (!failures.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (String failure : failures) {
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(failure);
            }
            throw new DeploymentException(message.toString());
        }
        this.environment.addToBundleClassPath(this.bundleClassPath);
        if (this.environment.getBundleActivator() == null) {
            this.environment.setBundleActivator(ConfigurationActivator.class.getName());
            this.environment.addImportPackage(DeploymentContext.getImportPackageName(ConfigurationActivator.class.getName()));
        }
        ArrayList<GBeanData> gbeans = new ArrayList<GBeanData>(this.configuration.getGBeans().values());
        Collections.sort(gbeans, new GBeanData.PriorityComparator());
        OSGiMetaDataBuilder osgiMetaDataBuilder = null;
        if (System.getProperty("geronimo.build.car") == null) {
            osgiMetaDataBuilder = new OSGiMetaDataBuilder(this.bundleContext);
            if (this.configuration.getModuleType() == ConfigurationModuleType.RAR) {
                this.environment.addDynamicImportPackage("*");
            }
        } else {
            LinkedHashSet<String> imports = DeploymentContext.getImports(gbeans);
            DeploymentContext.addImport(imports, this.environment.getBundleActivator());
            this.environment.addImportPackages(imports);
            if (this.environment.getDynamicImportPackages().isEmpty()) {
                this.environment.addDynamicImportPackage("*");
            }
            osgiMetaDataBuilder = new OSGiMetaDataBuilder(this.bundleContext, new DummyExportPackagesSelector());
        }
        try {
            osgiMetaDataBuilder.build(this.environment, this.configuration.getModuleType() == ConfigurationModuleType.CAR);
        }
        catch (IllegalConfigurationException e) {
            throw new DeploymentException((Throwable)e);
        }
        if (this.tempBundle != null) {
            try {
                this.createPluginMetadata();
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to update geronimo-plugin.xml", (Throwable)e);
            }
        }
        ConfigurationData configurationData = new ConfigurationData(this.configuration.getModuleType(), gbeans, this.childConfigurationDatas, this.configuration.getEnvironment(), this.baseDir, this.inPlaceConfigurationDir, this.naming);
        for (ConfigurationData ownedConfiguration : this.additionalDeployment) {
            configurationData.addOwnedConfigurations(ownedConfiguration.getId());
        }
        return configurationData;
    }

    public static LinkedHashSet<String> getImports(List<GBeanData> gbeans) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        for (GBeanData data : gbeans) {
            GBeanInfo info = data.getGBeanInfo();
            DeploymentContext.addImport(imports, info.getClassName());
            for (GAttributeInfo attInfo : info.getAttributes()) {
                DeploymentContext.addImport(imports, attInfo.getType());
            }
            for (GReferenceInfo refInfo : info.getReferences()) {
                DeploymentContext.addImport(imports, refInfo.getReferenceType());
            }
            for (GOperationInfo opInfo : info.getOperations()) {
                DeploymentContext.addImport(imports, opInfo.getReturnType());
                for (String paramType : opInfo.getParameterList()) {
                    DeploymentContext.addImport(imports, paramType);
                }
            }
        }
        return imports;
    }

    private static void addImport(LinkedHashSet<String> imports, String className) {
        String packageName = DeploymentContext.getImportPackageName(className);
        if (packageName == null || packageName.startsWith("java.")) {
            return;
        }
        imports.add(packageName);
    }

    private static String getImportPackageName(String className) {
        int pos = className.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        int count = 0;
        while (className.charAt(count) == '[') {
            ++count;
        }
        if (className.charAt(count) == 'L') {
            ++count;
        }
        className = className.substring(count, pos);
        return className;
    }

    public void addAdditionalDeployment(ConfigurationData configurationData) {
        this.additionalDeployment.add(configurationData);
    }

    public List<ConfigurationData> getAdditionalDeployment() {
        return this.additionalDeployment;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public List<String> verify(Configuration configuration) throws DeploymentException {
        ArrayList<String> failures = new ArrayList<String>();
        for (Map.Entry entry : this.configuration.getGBeans().entrySet()) {
            AbstractName name = (AbstractName)entry.getKey();
            GBeanData gbean = (GBeanData)entry.getValue();
            for (Map.Entry referenceEntry : gbean.getReferences().entrySet()) {
                ReferencePatterns referencePatterns;
                String referenceName = (String)referenceEntry.getKey();
                String failure = this.verifyReference(gbean, referenceName, referencePatterns = (ReferencePatterns)referenceEntry.getValue(), configuration);
                if (failure == null) continue;
                failures.add(failure);
            }
            for (ReferencePatterns referencePatterns : gbean.getDependencies()) {
                String failure = this.verifyDependency(name, referencePatterns, configuration);
                if (failure == null) continue;
                failures.add(failure);
            }
        }
        return failures;
    }

    private String verifyReference(GBeanData gbean, String referenceName, ReferencePatterns referencePatterns, Configuration configuration) {
        GReferenceInfo referenceInfo = gbean.getGBeanInfo().getReference(referenceName);
        if (referenceInfo == null) {
            return null;
        }
        if (referenceInfo.getProxyType().equals(Collection.class.getName())) {
            return null;
        }
        String message = this.isVerifyReference(referencePatterns, configuration);
        if (message != null) {
            return "Unable to resolve reference \"" + referenceName + "\"\n" + "    in gbean " + gbean.getAbstractName() + "\n    to a gbean matching the pattern " + referencePatterns.getPatterns() + "\n    due to: " + message;
        }
        return null;
    }

    private String verifyDependency(AbstractName name, ReferencePatterns referencePatterns, Configuration configuration) {
        String message = this.isVerifyReference(referencePatterns, configuration);
        if (message != null) {
            return "Unable to resolve dependency in gbean " + name + "\n    to a gbean matching the pattern " + referencePatterns.getPatterns() + "\n    due to: " + message;
        }
        return null;
    }

    private String isVerifyReference(ReferencePatterns referencePatterns, Configuration configuration) {
        if (referencePatterns.isResolved()) {
            return null;
        }
        Set patterns = referencePatterns.getPatterns();
        for (AbstractNameQuery query : patterns) {
            if (query.getArtifact() == null) continue;
            return null;
        }
        try {
            configuration.findGBean(patterns);
            return null;
        }
        catch (GBeanNotFoundException e) {
            if (e.hasMatches()) {
                return null;
            }
            return e.getMessage();
        }
    }

    private class DefaultJarFileFactory
    implements ClassPathUtils.JarFileFactory {
        private DefaultJarFileFactory() {
        }

        @Override
        public JarFile newJarFile(URI relativeURI) throws IOException {
            File targetFile = DeploymentContext.this.getTargetFile(relativeURI);
            try {
                return new JarFile(targetFile);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Could not create JarFile for file: " + targetFile).initCause(e);
            }
        }

        @Override
        public String getManifestClassPath(JarFile jarFile) throws IOException {
            java.util.jar.Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return null;
            }
            return manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        }

        @Override
        public boolean isDirectory(URI relativeURI) {
            File targetFile = DeploymentContext.this.getTargetFile(relativeURI);
            return targetFile.isDirectory();
        }

        @Override
        public File[] listFiles(URI relativeURI) throws IOException {
            File targetFile = DeploymentContext.this.getTargetFile(relativeURI);
            if (targetFile.isDirectory()) {
                File[] files = targetFile.listFiles();
                return files == null ? new File[]{} : files;
            }
            throw new IOException(targetFile + " is not a directory");
        }
    }
}

