/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.util.osgi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.common.IllegalConfigurationException;
import org.apache.geronimo.deployment.util.osgi.ExportPackagesSelector;
import org.apache.geronimo.deployment.util.osgi.HighVersionFirstExportPackagesSelector;
import org.apache.geronimo.deployment.util.osgi.OSGiBuildContext;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.system.configuration.DependencyManager;
import org.apache.xbean.osgi.bundle.util.BundleDescription;
import org.apache.xbean.osgi.bundle.util.HeaderParser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiMetaDataBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OSGiMetaDataBuilder.class);
    private static final boolean USE_FIXED_IMPORT_PACKAGE_VERSION = Boolean.parseBoolean(System.getProperty("org.apache.geronimo.deployment.import_package.fixed_version", "true"));
    private static final Version ZERO_VERSION = new Version(0, 0, 0);
    private BundleContext bundleContext;
    private ExportPackagesSelector exportPackagesSelector;

    public OSGiMetaDataBuilder(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.exportPackagesSelector = new HighVersionFirstExportPackagesSelector();
    }

    public OSGiMetaDataBuilder(BundleContext bundleContext, ExportPackagesSelector exportPackagesSelector) {
        this.bundleContext = bundleContext;
        this.exportPackagesSelector = exportPackagesSelector;
    }

    public void build(Environment environment) throws IllegalConfigurationException {
        this.build(environment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Environment environment, boolean clientModule) throws IllegalConfigurationException {
        this.processClassloadingRules(environment);
        ServiceReference serviceReference = null;
        try {
            serviceReference = this.bundleContext.getServiceReference(DependencyManager.class.getName());
            DependencyManager dependencyManager = null;
            if (serviceReference != null) {
                dependencyManager = (DependencyManager)this.bundleContext.getService(serviceReference);
            }
            OSGiBuildContext context = this.createOSGiBuildContext(environment, dependencyManager, clientModule);
            this.processImportPackages(context);
        }
        finally {
            if (serviceReference != null) {
                this.bundleContext.ungetService(serviceReference);
            }
        }
    }

    protected void processClassloadingRules(Environment environment) {
        for (String hiddenClassPrefix : environment.getClassLoadingRules().getHiddenRule().getClassPrefixes()) {
            String inversedImportPackage = hiddenClassPrefix.endsWith("*") ? hiddenClassPrefix : hiddenClassPrefix + "*";
            environment.addImportPackage("!" + inversedImportPackage);
        }
    }

    protected OSGiBuildContext createOSGiBuildContext(Environment environment, DependencyManager dependencyManager, boolean clientModule) throws IllegalConfigurationException {
        ArrayList<String> hiddenImportPackageNamePrefixes = new ArrayList<String>();
        HashSet<String> hiddenImportPackageNames = new HashSet<String>();
        HashSet<String> removedImportPackages = new HashSet<String>();
        for (String initialImportPackageName : environment.getImportPackages()) {
            String importPackageName = initialImportPackageName.trim();
            if (importPackageName.length() == 0) {
                removedImportPackages.add(initialImportPackageName);
                continue;
            }
            if (importPackageName.startsWith("!")) {
                boolean wildcardImportPakcageName = (importPackageName = importPackageName.substring(1)).endsWith("*");
                if (wildcardImportPakcageName) {
                    importPackageName = importPackageName.substring(0, importPackageName.length() - 1);
                }
                if (importPackageName.endsWith(".")) {
                    importPackageName = importPackageName.substring(0, importPackageName.length() - 1);
                }
                if (wildcardImportPakcageName) {
                    hiddenImportPackageNamePrefixes.add(importPackageName);
                } else {
                    hiddenImportPackageNames.add(importPackageName);
                }
                removedImportPackages.add(initialImportPackageName);
                continue;
            }
            if (!importPackageName.endsWith("*")) continue;
            throw new IllegalConfigurationException("wildchar * could not be used in the import-package " + importPackageName + " without ! prefix");
        }
        environment.removeImportPackages(removedImportPackages);
        removedImportPackages.clear();
        block1: for (String importPackageName : environment.getImportPackages()) {
            if (hiddenImportPackageNames.contains(importPackageName)) {
                removedImportPackages.add(importPackageName);
                continue;
            }
            for (String hiddenImportPackageNamePrefix : hiddenImportPackageNamePrefixes) {
                if (!importPackageName.startsWith(hiddenImportPackageNamePrefix)) continue;
                removedImportPackages.add(importPackageName);
                continue block1;
            }
        }
        environment.removeImportPackages(removedImportPackages);
        for (String importPackageName : environment.getImportPackages()) {
            List elements = HeaderParser.parseHeader((String)importPackageName);
            for (HeaderParser.HeaderElement headerElement : elements) {
                hiddenImportPackageNames.add(headerElement.getName());
            }
        }
        HashSet<String> removedDynamicImportPackages = new HashSet<String>();
        for (String initialDynamicImportPackageName : environment.getDynamicImportPackages()) {
            String dynamicImportPackageName = initialDynamicImportPackageName.trim();
            if (dynamicImportPackageName.length() == 0) {
                removedDynamicImportPackages.add(initialDynamicImportPackageName);
                continue;
            }
            if (dynamicImportPackageName.startsWith("!")) {
                throw new IllegalConfigurationException("DynamicImport-Package " + dynamicImportPackageName + " could not be configured with ! prefix");
            }
            List elements = HeaderParser.parseHeader((String)dynamicImportPackageName);
            for (HeaderParser.HeaderElement headerElement : elements) {
                hiddenImportPackageNames.add(headerElement.getName());
            }
        }
        environment.removeDynamicImportPackages(removedDynamicImportPackages);
        OSGiBuildContext osgiBuildContext = new OSGiBuildContext(environment, hiddenImportPackageNamePrefixes, hiddenImportPackageNames, dependencyManager, environment.getClassLoadingRules().isInverseClassLoading());
        osgiBuildContext.setClientModule(clientModule);
        if (clientModule) {
            osgiBuildContext.setClientArtifactResolver(this.getClientArtifactResolver());
        }
        return osgiBuildContext;
    }

    protected void processImportPackages(OSGiBuildContext context) {
        Environment environment = context.getEnvironment();
        Map<Long, Set<BundleDescription.ExportPackage>> selectedExportPackages = this.exportPackagesSelector.select(context);
        for (Map.Entry<Long, Set<BundleDescription.ExportPackage>> entry : selectedExportPackages.entrySet()) {
            String importPackageName;
            if (context.isInverseClassLoading()) {
                for (BundleDescription.ExportPackage exportPackage : entry.getValue()) {
                    importPackageName = this.toImportPackageName(exportPackage);
                    if (importPackageName == null) continue;
                    environment.addDynamicImportPackage(importPackageName);
                }
                continue;
            }
            for (BundleDescription.ExportPackage exportPackage : entry.getValue()) {
                importPackageName = this.toImportPackageName(exportPackage);
                if (importPackageName == null) continue;
                environment.addImportPackage(importPackageName);
            }
        }
        selectedExportPackages.clear();
    }

    protected String toImportPackageName(BundleDescription.ExportPackage exportPackage) {
        if (USE_FIXED_IMPORT_PACKAGE_VERSION) {
            return exportPackage.getName() + ";version=" + "\"[" + exportPackage.getVersion() + "," + exportPackage.getVersion() + "]\"";
        }
        return exportPackage.getVersion().equals((Object)ZERO_VERSION) ? exportPackage.getName() : exportPackage.getName() + ";version=" + exportPackage.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArtifactResolver getClientArtifactResolver() {
        ArtifactResolver artifactResolver;
        ServiceReference kernelReference = null;
        try {
            kernelReference = this.bundleContext.getServiceReference(Kernel.class.getName());
            if (kernelReference == null) {
                ArtifactResolver artifactResolver2 = null;
                return artifactResolver2;
            }
            Kernel kernel = (Kernel)this.bundleContext.getService(kernelReference);
            artifactResolver = (ArtifactResolver)kernel.getGBean("ClientArtifactResolver");
        }
        catch (GBeanNotFoundException e) {
            logger.warn("Fail to get client artifact resolver, OSGi metadata for client module might not generate correctly", (Throwable)e);
            ArtifactResolver artifactResolver3 = null;
            return artifactResolver3;
        }
        catch (InternalKernelException e) {
            logger.warn("Fail to get client artifact resolver, OSGi metadata for client module might not generate correctly", (Throwable)e);
            ArtifactResolver artifactResolver4 = null;
            return artifactResolver4;
        }
        catch (IllegalStateException e2) {
            logger.warn("Fail to get client artifact resolver, OSGi metadata for client module might not generate correctly", (Throwable)e2);
            ArtifactResolver artifactResolver5 = null;
            return artifactResolver5;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (kernelReference != null) {
                try {
                    this.bundleContext.ungetService(kernelReference);
                }
                catch (Exception e) {}
            }
        }
        return artifactResolver;
    }
}

