/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.NestedJarFile;

class InPlaceResourceContext
implements ResourceContext {
    private static final String PACKED_MODULED_SAVED_SUFFIX = ".saved";
    private final DeploymentContext deploymentContext;
    private final URI inPlaceBaseConfigurationUri;
    private final Set<ZipFile> zipFilesToExpand = new HashSet<ZipFile>();

    public InPlaceResourceContext(DeploymentContext deploymentContext, File inPlaceBaseConfigurationDir) throws DeploymentException {
        this.deploymentContext = deploymentContext;
        this.inPlaceBaseConfigurationUri = inPlaceBaseConfigurationDir.toURI();
        if (inPlaceBaseConfigurationDir.isFile()) {
            deploymentContext.addToClassPath("");
        }
    }

    @Override
    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        NestedJarFile nestedJarFile;
        if (zipFile instanceof NestedJarFile && (nestedJarFile = (NestedJarFile)zipFile).isPacked()) {
            this.zipFilesToExpand.add(zipFile);
        }
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addInclude(URI targetPath, URL source) throws IOException {
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addInclude(URI targetPath, File source) throws IOException {
        this.deploymentContext.addToClassPath(targetPath.toString());
    }

    @Override
    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        NestedJarFile nestedJarFile;
        if (zipFile instanceof NestedJarFile && (nestedJarFile = (NestedJarFile)zipFile).isPacked()) {
            this.zipFilesToExpand.add(zipFile);
        }
    }

    @Override
    public void addFile(URI targetPath, URL source) throws IOException {
    }

    @Override
    public void addFile(URI targetPath, File source) throws IOException {
    }

    @Override
    public void addFile(URI targetPath, String source) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(URI targetPath, byte[] contents) throws IOException {
        File file = this.getTargetFile(targetPath);
        if (!file.getParentFile().mkdirs()) {
            throw new IOException("Could not create parent directory for entry: " + targetPath + " at " + file.getParentFile());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(contents);
        }
        finally {
            IOUtils.close((Closeable)out);
        }
    }

    @Override
    public File getTargetFile(URI targetPath) {
        if (targetPath == null) {
            throw new NullPointerException("targetPath is null");
        }
        if (targetPath.isAbsolute()) {
            throw new IllegalArgumentException("targetPath is absolute");
        }
        if (targetPath.isOpaque()) {
            throw new IllegalArgumentException("targetPath is opaque");
        }
        return new File(this.inPlaceBaseConfigurationUri.resolve(targetPath));
    }

    @Override
    public URL getTargetURL(URI targetPath) {
        File file = this.getTargetFile(targetPath);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL", e);
        }
    }

    @Override
    public void flush() throws IOException {
        for (ZipFile zipFile : this.zipFilesToExpand) {
            File targetFile;
            String name = zipFile.getName();
            zipFile.close();
            File srcFile = new File(name);
            if (!srcFile.isAbsolute()) {
                srcFile = new File(this.inPlaceBaseConfigurationUri.resolve(name));
                try {
                    targetFile = this.getTargetFile(new URI(name + PACKED_MODULED_SAVED_SUFFIX));
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                targetFile = new File(name + PACKED_MODULED_SAVED_SUFFIX);
            }
            boolean success = new File(name).renameTo(targetFile);
            if (!success) {
                throw new IOException("Cannot rename file " + name + " to " + targetFile.getAbsolutePath());
            }
            JarUtils.unzipToDirectory((ZipFile)new ZipFile(targetFile), (File)srcFile);
        }
    }
}

