/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandLogin
extends AbstractCommand {
    @Override
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        try {
            File authFile = new File(System.getProperty("user.home"), ".geronimo-deployer");
            if (!authFile.exists() && !authFile.createNewFile()) {
                throw new DeploymentException("Unable to create " + authFile.getAbsolutePath() + " to hold saved logins");
            }
            if (!authFile.canRead() || !authFile.canWrite()) {
                throw new DeploymentException("Saved login file " + authFile.getAbsolutePath() + " is not readable or not writable");
            }
            Properties props = new Properties();
            BufferedInputStream authIn = new BufferedInputStream(new FileInputStream(authFile));
            props.load(authIn);
            ((InputStream)authIn).close();
            props.setProperty("login." + connection.getServerURI(), EncryptionManager.encrypt((Serializable)connection.getAuthentication()));
            BufferedOutputStream save = new BufferedOutputStream(new FileOutputStream(authFile));
            props.store(save, "Saved authentication information to connect to Geronimo servers");
            ((OutputStream)save).flush();
            ((OutputStream)save).close();
            consoleReader.printString(DeployUtils.reformat("Saved login for: " + connection.getServerURI(), 4, 72));
            consoleReader.printNewline();
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to save authentication to login file", (Throwable)e);
        }
    }
}

