/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.cli.deployer.ConnectionParams;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.kernel.util.JarUtils;

public class OnlineServerConnection
extends ServerConnection {
    private final DeploymentFactory geronimoDeploymentFactory;
    private final ServerConnection.UsernamePasswordHandler handler;
    private boolean logToSysErr;
    private boolean verboseMessages;

    public OnlineServerConnection(ConnectionParams params, ConsoleReader consoleReader, DeploymentFactory geronimoDeploymentFactory) throws DeploymentException {
        this(params, new DefaultUserPasswordHandler(consoleReader), geronimoDeploymentFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineServerConnection(ConnectionParams params, ServerConnection.UsernamePasswordHandler handler, DeploymentFactory geronimoDeploymentFactory) throws DeploymentException {
        this.geronimoDeploymentFactory = geronimoDeploymentFactory;
        this.handler = handler;
        String uri = params.getURI();
        String driver = params.getDriver();
        String user = params.getUser();
        String password = params.getPassword();
        String host = params.getHost();
        Integer port = params.getPort();
        this.verboseMessages = params.isVerbose();
        this.logToSysErr = params.isSyserr();
        boolean secure = params.isSecure();
        if (driver != null && uri == null) {
            throw new DeploymentSyntaxException("A custom driver requires a custom URI");
        }
        if (params.isOffline()) {
            throw new DeploymentException("Offline connection is not supported");
        }
        if (host != null || port != null) {
            uri = DeployUtils.getConnectionURI(host, port, secure);
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DeployUtils.class.getClassLoader());
        try {
            this.tryToConnect(uri, driver, user, password, secure);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        if (this.manager == null) {
            throw new DeploymentException("Unexpected error; connection failed.");
        }
    }

    private void tryToConnect(String argURI, String driver, String user, String password, boolean secure) throws DeploymentException {
        String useURI;
        DeploymentFactoryManager mgr = DeploymentFactoryManager.getInstance();
        if (driver != null) {
            this.loadDriver(driver, mgr);
        } else {
            mgr.registerDeploymentFactory(this.geronimoDeploymentFactory);
        }
        String string = useURI = argURI == null ? DeployUtils.getConnectionURI(null, null, secure) : argURI;
        if (user == null && password == null) {
            try {
                DeployUtils.SavedAuthentication savedAuthentication = DeployUtils.readSavedCredentials(useURI);
                if (savedAuthentication != null) {
                    user = savedAuthentication.getUser();
                    password = new String(savedAuthentication.getPassword());
                }
            }
            catch (IOException e) {
                System.out.println("Warning: " + e.getMessage());
            }
        }
        if (secure) {
            DeployUtils.setSecurityProperties();
        }
        if (user == null || password == null) {
            try {
                if (user == null) {
                    user = this.handler.getUsername();
                }
                if (password == null) {
                    password = this.handler.getPassword();
                }
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to prompt for login", (Throwable)e);
            }
        }
        try {
            this.manager = mgr.getDeploymentManager(useURI, user, password);
            this.auth = new DeployUtils.SavedAuthentication(useURI, user, password == null ? null : password.toCharArray());
        }
        catch (AuthenticationFailedException e) {
            throw new DeploymentException("Login Failed");
        }
        catch (DeploymentManagerCreationException e) {
            throw new DeploymentException("Unable to connect to server at " + useURI + " -- " + e.getMessage(), (Throwable)e);
        }
        if (this.manager instanceof JMXDeploymentManager) {
            JMXDeploymentManager deploymentManager = (JMXDeploymentManager)this.manager;
            deploymentManager.setLogConfiguration(this.logToSysErr, this.verboseMessages);
        }
    }

    private void loadDriver(String driver, DeploymentFactoryManager mgr) throws DeploymentException {
        File file = new File(driver);
        try {
            if (!(file.exists() && file.canRead() && JarUtils.isJarFile((File)file))) {
                throw new DeploymentSyntaxException("Driver '" + file.getAbsolutePath() + "' is not a readable JAR file");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Driver '" + file.getAbsolutePath() + "' is not a readable JAR file");
        }
        String className = null;
        try {
            JarFile jar = new JarFile(file);
            className = jar.getManifest().getMainAttributes().getValue("J2EE-DeploymentFactory-Implementation-Class");
            if (className == null) {
                throw new DeploymentException("The driver JAR " + file.getAbsolutePath() + " does not specify a J2EE-DeploymentFactory-Implementation-Class; cannot load driver.");
            }
            jar.close();
            DeploymentFactory factory = (DeploymentFactory)Class.forName(className).newInstance();
            mgr.registerDeploymentFactory(factory);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentSyntaxException("Unable to load driver class " + className + " from JAR " + file.getAbsolutePath(), e);
        }
    }

    private static class DefaultUserPasswordHandler
    implements ServerConnection.UsernamePasswordHandler {
        private ConsoleReader consoleReader;

        public DefaultUserPasswordHandler(ConsoleReader consoleReader) {
            this.consoleReader = consoleReader;
        }

        @Override
        public String getPassword() throws IOException {
            return new String(this.consoleReader.readPassword("Password: "));
        }

        @Override
        public String getUsername() throws IOException {
            return this.consoleReader.readLine("Username: ");
        }
    }
}

